/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.predicates;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Sets;
import java.util.HashSet;
import org.jclouds.compute.domain.Image;

public class ImagePredicates {
    public static Predicate<Image> idIn(Iterable<String> ids) {
        Preconditions.checkNotNull(ids, "ids must be defined");
        final HashSet<String> search = Sets.newHashSet(ids);
        return new Predicate<Image>(){

            @Override
            public boolean apply(Image image) {
                return search.contains(image.getId());
            }

            public String toString() {
                return "idIn(" + search + ")";
            }
        };
    }

    public static Predicate<Image> userMetadataContains(final String key, final String value) {
        Preconditions.checkNotNull(key, "key must be defined");
        Preconditions.checkNotNull(value, "value must be defined");
        return new Predicate<Image>(){

            @Override
            public boolean apply(Image image) {
                return value.equals(image.getUserMetadata().get(key));
            }

            public String toString() {
                return "metadataContains(" + key + ", " + value + ")";
            }
        };
    }

    public static Predicate<Image> idEquals(final String id) {
        Preconditions.checkNotNull(id, "id must be defined");
        return new Predicate<Image>(){

            @Override
            public boolean apply(Image image) {
                return id.equals(image.getId());
            }

            public String toString() {
                return "idEquals(" + id + ")";
            }
        };
    }

    public static Predicate<Image> is64Bit() {
        return new Is64BitPredicate();
    }

    public static Predicate<Image> any() {
        return Predicates.alwaysTrue();
    }

    private static final class Is64BitPredicate
    implements Predicate<Image> {
        private Is64BitPredicate() {
        }

        @Override
        public boolean apply(Image image) {
            return image.getOperatingSystem().is64Bit();
        }

        public String toString() {
            return "is64Bit()";
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof Is64BitPredicate;
        }

        public int hashCode() {
            return 0;
        }
    }
}

