/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.xml;

import com.google.common.base.Strings;
import org.jclouds.ec2.domain.Tag;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.util.SaxUtils;
import org.xml.sax.SAXException;

public class TagHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<Tag> {
    private StringBuilder currentText = new StringBuilder();
    private Tag.Builder builder = Tag.builder();

    @Override
    public Tag getResult() {
        try {
            Tag tag = this.builder.build();
            return tag;
        }
        finally {
            this.builder = Tag.builder();
        }
    }

    @Override
    public void endElement(String uri, String name, String qName) throws SAXException {
        if (SaxUtils.equalsOrSuffix(qName, "resourceId")) {
            this.builder.resourceId(SaxUtils.currentOrNull(this.currentText));
        } else if (SaxUtils.equalsOrSuffix(qName, "resourceType")) {
            this.builder.resourceType(SaxUtils.currentOrNull(this.currentText));
        } else if (SaxUtils.equalsOrSuffix(qName, "key")) {
            this.builder.key(SaxUtils.currentOrNull(this.currentText));
        } else if (SaxUtils.equalsOrSuffix(qName, "value")) {
            this.builder.value(Strings.emptyToNull(SaxUtils.currentOrNull(this.currentText)));
        }
        this.currentText.setLength(0);
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }
}

