/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.auth.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.jclouds.domain.Credentials;
import org.jclouds.logging.Logger;
import org.jclouds.openstack.keystone.auth.domain.AuthInfo;
import org.jclouds.openstack.keystone.auth.domain.TenantOrDomainAndCredentials;

public abstract class BaseAuthenticator<C>
implements Function<Credentials, AuthInfo> {
    @Resource
    protected Logger logger = Logger.NULL;
    @Inject(optional=true)
    @Named(value="jclouds.keystone.tenant-name")
    protected String defaultTenantName;
    @Inject(optional=true)
    @Named(value="jclouds.keystone.tenant-id")
    protected String defaultTenantId;
    @Inject(optional=true)
    @Named(value="jclouds.keystone.requires-tenant")
    protected boolean requiresTenant;
    @Inject(optional=true)
    @Named(value="jclouds.keystone.scope")
    protected String scope = "unscoped";
    @Inject(optional=true)
    @Named(value="jclouds.keystone.project-domain-name")
    protected String projectDomainName;
    @Inject(optional=true)
    @Named(value="jclouds.keystone.project-domain-id")
    protected String projectDomainId;

    @PostConstruct
    public void checkPropertiesAreCompatible() {
        Preconditions.checkState(this.defaultTenantName == null || this.defaultTenantId == null, "you cannot specify both %s and %s", (Object)"jclouds.keystone.tenant-name", (Object)"jclouds.keystone.tenant-id");
        Preconditions.checkState(this.projectDomainName == null || this.projectDomainId == null, "you cannot specify both %s and %s", (Object)"jclouds.keystone.project-domain-name", (Object)"jclouds.keystone.project-domain-id");
    }

    @Override
    public AuthInfo apply(Credentials input) {
        String tenantName = this.defaultTenantName;
        String usernameOrAccessKey = input.identity;
        String passwordOrSecretKeyOrToken = input.credential;
        if (this.defaultTenantName == null && input.identity.indexOf(58) != -1) {
            tenantName = input.identity.substring(0, input.identity.lastIndexOf(58));
            usernameOrAccessKey = input.identity.substring(input.identity.lastIndexOf(58) + 1);
        }
        if (this.defaultTenantId == null && tenantName == null && this.requiresTenant) {
            throw new IllegalArgumentException(String.format("current configuration is set to [%s]. Unless you set [%s] or [%s], you must prefix your identity with 'tenantName:'", "jclouds.keystone.requires-tenant", "jclouds.keystone.tenant-name", "jclouds.keystone.tenant-id"));
        }
        C creds = this.createCredentials(usernameOrAccessKey, passwordOrSecretKeyOrToken);
        TenantOrDomainAndCredentials credsWithTenant = TenantOrDomainAndCredentials.builder().tenantOrDomainId(this.defaultTenantId).tenantOrDomainName(tenantName).scope(this.scope).projectDomainName(this.projectDomainName).projectDomainId(this.projectDomainId).credentials(creds).build();
        return this.authenticate(credsWithTenant);
    }

    public abstract C createCredentials(String var1, String var2);

    public abstract AuthInfo authenticate(TenantOrDomainAndCredentials<C> var1);
}

