/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.profitbricks.http.parser.datacenter;

import com.google.common.collect.Lists;
import java.util.List;
import org.jclouds.profitbricks.domain.DataCenter;
import org.jclouds.profitbricks.domain.Location;
import org.jclouds.profitbricks.domain.ProvisioningState;
import org.jclouds.profitbricks.http.parser.datacenter.BaseDataCenterResponseHandler;
import org.xml.sax.SAXException;

public class DataCenterListResponseHandler
extends BaseDataCenterResponseHandler<List<DataCenter>> {
    private final List<DataCenter> dataCenters = Lists.newArrayList();

    DataCenterListResponseHandler() {
    }

    @Override
    public List<DataCenter> getResult() {
        return this.dataCenters;
    }

    @Override
    protected void setPropertyOnEndTag(String qName) {
        super.setPropertyOnEndTag(qName);
        if ("dataCenterName".equals(qName)) {
            this.builder.name(this.textToStringValue());
        } else if ("location".equals(qName)) {
            this.builder.location(Location.fromValue(this.textToStringValue()));
        } else if ("provisioningState".equals(qName)) {
            this.builder.state(ProvisioningState.fromValue(this.textToStringValue()));
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.setPropertyOnEndTag(qName);
        if ("return".equals(qName)) {
            this.dataCenters.add(this.builder.build());
            this.builder = DataCenter.builder();
        }
        this.clearTextBuffer();
    }
}

