/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.filters;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.reflect.Invokable;
import java.util.Map;
import javax.inject.Inject;
import org.jclouds.http.HttpException;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpRequestFilter;
import org.jclouds.rest.config.InvocationConfig;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.jclouds.util.Maps2;
import org.jclouds.util.Predicates2;

public class ApiVersionFilter
implements HttpRequestFilter {
    private final InvocationConfig config;
    private final Map<String, String> versions;

    @Inject
    ApiVersionFilter(InvocationConfig config, Function<Predicate<String>, Map<String, String>> filterStringsBoundByName) {
        this.config = config;
        this.versions = ApiVersionFilter.versions(filterStringsBoundByName);
    }

    @Override
    public HttpRequest filter(HttpRequest request) throws HttpException {
        Preconditions.checkArgument(request instanceof GeneratedHttpRequest, "This filter can only be applied to GeneratedHttpRequest objects");
        GeneratedHttpRequest generatedRequest = (GeneratedHttpRequest)request;
        String commandName = this.config.getCommandName(generatedRequest.getInvocation());
        String customApiVersion = this.versions.get(commandName);
        if (customApiVersion == null) {
            Invokable<?, ?> invoked = generatedRequest.getInvocation().getInvokable();
            String className = invoked.getOwnerType().getRawType().getSimpleName();
            customApiVersion = this.versions.get(className);
        }
        if (customApiVersion != null) {
            return ((HttpRequest.Builder)((HttpRequest.Builder)request.toBuilder()).replaceQueryParam("api-version", customApiVersion)).build();
        }
        return request;
    }

    private static Map<String, String> versions(Function<Predicate<String>, Map<String, String>> filterStringsBoundByName) {
        Map<String, String> stringBoundWithApiVersionPrefix = filterStringsBoundByName.apply(Predicates2.startsWith("jclouds.azurecompute.arm.apiversion."));
        return Maps2.transformKeys(stringBoundWithApiVersionPrefix, new Function<String, String>(){

            @Override
            public String apply(String input) {
                return input.replaceFirst("jclouds.azurecompute.arm.apiversion.", "");
            }
        });
    }
}

