/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.domain.internal;

import com.google.common.base.Optional;
import com.google.common.base.Supplier;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.HardwareBuilder;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.Processor;
import org.jclouds.compute.domain.TemplateBuilder;
import org.jclouds.compute.domain.internal.TemplateBuilderImpl;
import org.jclouds.compute.domain.internal.VolumeImpl;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.compute.util.AutomaticHardwareIdSpec;
import org.jclouds.domain.Location;

public class ArbitraryCpuRamTemplateBuilderImpl
extends TemplateBuilderImpl {
    @Inject
    protected ArbitraryCpuRamTemplateBuilderImpl(@Memoized Supplier<Set<? extends Location>> locations, @Memoized Supplier<Set<? extends Image>> images, @Memoized Supplier<Set<? extends Hardware>> hardwares, Supplier<Location> defaultLocation, @Named(value="DEFAULT") Provider<TemplateOptions> optionsProvider, @Named(value="DEFAULT") Provider<TemplateBuilder> defaultTemplateProvider) {
        super(locations, images, hardwares, defaultLocation, optionsProvider, defaultTemplateProvider);
    }

    protected Hardware automaticHardware(double cores, int ram, Optional<Float> diskSize) {
        HardwareBuilder builder = new HardwareBuilder();
        if (diskSize.isPresent() && diskSize.get().floatValue() > 0.0f) {
            builder.volume(new VolumeImpl(diskSize.get(), true, true));
        }
        return builder.id(AutomaticHardwareIdSpec.automaticHardwareIdSpecBuilder(cores, ram, diskSize).toString()).ram(ram).processor(new Processor(cores, 1.0)).build();
    }

    @Override
    protected Hardware findHardwareWithId(Set<? extends Hardware> hardwaresToSearch) {
        try {
            return super.findHardwareWithId(hardwaresToSearch);
        }
        catch (NoSuchElementException ex) {
            if (AutomaticHardwareIdSpec.isAutomaticId(this.hardwareId)) {
                AutomaticHardwareIdSpec spec = AutomaticHardwareIdSpec.parseId(this.hardwareId);
                return this.automaticHardware(spec.getCores(), spec.getRam(), spec.getDisk());
            }
            throw ex;
        }
    }

    @Override
    protected Hardware resolveHardware(Set<? extends Hardware> hardwarel, Iterable<? extends Image> images) {
        try {
            return super.resolveHardware(hardwarel, images);
        }
        catch (NoSuchElementException ex) {
            if (this.minCores <= 0.0 || this.minRam == 0 || this.minDisk < 0.0) {
                throw new IllegalArgumentException("No hardware profile matching the given criteria was found. If you want to use exact values, please set the minCores, minRam and minDisk to positive values.");
            }
            return this.automaticHardware(this.minCores, this.minRam, this.minDisk == 0.0 ? Optional.absent() : Optional.of(Float.valueOf((float)this.minDisk)));
        }
    }
}

