/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.config;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import org.jclouds.Context;
import org.jclouds.View;

public class ContextLinking {
    static final TypeLiteral<Supplier<Context>> CONTEXT_SUPPLIER = new TypeLiteral<Supplier<Context>>(){};
    static final TypeLiteral<Supplier<View>> VIEW_SUPPLIER = new TypeLiteral<Supplier<View>>(){};
    private static final Function<View, Context> ViewToContext = new Function<View, Context>(){

        @Override
        public Context apply(View input) {
            return input.unwrap();
        }
    };

    public static Module linkView(final String id, final Supplier<View> view) {
        return new AbstractModule(){

            @Override
            protected void configure() {
                this.bind(VIEW_SUPPLIER).annotatedWith(Names.named(id)).toInstance(view);
                this.bind(CONTEXT_SUPPLIER).annotatedWith(Names.named(id)).toInstance(Suppliers.compose(ViewToContext, view));
            }
        };
    }

    public static Module linkContext(final String id, final Supplier<Context> context) {
        return new AbstractModule(){

            @Override
            protected void configure() {
                this.bind(CONTEXT_SUPPLIER).annotatedWith(Names.named(id)).toInstance(context);
            }
        };
    }

    public static Module linkView(View view) {
        return ContextLinking.linkView(view.unwrap().getId(), Suppliers.ofInstance(view));
    }

    public static Module linkContext(Context context) {
        return ContextLinking.linkContext(context.getId(), Suppliers.ofInstance(context));
    }
}

