/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.digitalocean2.domain;

import com.google.common.base.Strings;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jclouds.digitalocean2.domain.AutoValue_OperatingSystem;
import org.jclouds.digitalocean2.domain.Distribution;

public abstract class OperatingSystem {
    private static final Pattern VERSION_PATTERN = Pattern.compile("(?:[a-zA-Z\\s]*\\s+)?(\\d+(?:\\.?\\d+)*)?(?:\\s*(x\\d{2}))?.*");
    private static final String IS_64_BIT = "x64";

    public abstract Distribution distribution();

    public abstract String version();

    public abstract String arch();

    public static OperatingSystem create(String name, String distribution) {
        return new AutoValue_OperatingSystem(Distribution.fromValue(distribution), OperatingSystem.match(VERSION_PATTERN, name, 1), OperatingSystem.match(VERSION_PATTERN, name, 2));
    }

    public boolean is64bit() {
        return IS_64_BIT.equals(this.arch());
    }

    OperatingSystem() {
    }

    private static String match(Pattern pattern, String input, int group) {
        Matcher m3 = pattern.matcher(input);
        return m3.find() ? Strings.nullToEmpty(m3.group(group)) : "";
    }
}

