/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.binders;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.Map;
import org.jclouds.ec2.domain.BlockDevice;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.utils.Queries;
import org.jclouds.io.Payloads;
import org.jclouds.rest.Binder;

public class BindBlockDeviceMappingToIndexedFormParams
implements Binder {
    private static final String deviceNamePattern = "BlockDeviceMapping.%d.DeviceName";
    private static final String deleteOnTerminationPattern = "BlockDeviceMapping.%d.Ebs.DeleteOnTermination";
    private static final String volumeIdPattern = "BlockDeviceMapping.%d.Ebs.VolumeId";

    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        Preconditions.checkArgument(Preconditions.checkNotNull(input, "input") instanceof Map, "this binder is only valid for Map");
        Map blockDeviceMapping = (Map)input;
        Multimap<String, String> original = Queries.queryParser().apply(request.getPayload().getRawContent().toString());
        ImmutableMultimap.Builder<String, String> builder = ImmutableMultimap.builder();
        builder.putAll("Action", "ModifyInstanceAttribute");
        int amazonOneBasedIndex = 1;
        for (Map.Entry ebsBlockDeviceName : blockDeviceMapping.entrySet()) {
            builder.put(String.format(deviceNamePattern, amazonOneBasedIndex), (String)ebsBlockDeviceName.getKey());
            builder.put(String.format(deleteOnTerminationPattern, amazonOneBasedIndex), String.valueOf(((BlockDevice)ebsBlockDeviceName.getValue()).isDeleteOnTermination()));
            builder.put(String.format(volumeIdPattern, amazonOneBasedIndex), ((BlockDevice)ebsBlockDeviceName.getValue()).getVolumeId());
            ++amazonOneBasedIndex;
        }
        builder.putAll("InstanceId", (Iterable<String>)original.get("InstanceId"));
        request.setPayload(Payloads.newUrlEncodedFormPayload(builder.build()));
        return request;
    }
}

