/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.neutron.v2.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import java.beans.ConstructorProperties;
import org.jclouds.javax.annotation.Nullable;

public class AllocationPool {
    protected final String start;
    protected final String end;

    @ConstructorProperties(value={"start", "end"})
    protected AllocationPool(String start, String end) {
        this.start = start;
        this.end = end;
    }

    @Nullable
    public String getStart() {
        return this.start;
    }

    @Nullable
    public String getEnd() {
        return this.end;
    }

    public int hashCode() {
        return Objects.hashCode(this.start, this.end);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AllocationPool that = (AllocationPool)AllocationPool.class.cast(obj);
        return Objects.equal(this.start, that.start) && Objects.equal(this.end, that.end);
    }

    protected MoreObjects.ToStringHelper string() {
        return MoreObjects.toStringHelper(this).add("start", this.start).add("end", this.end);
    }

    public String toString() {
        return this.string().toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().fromAllocationPool(this);
    }

    public static class Builder {
        protected String start;
        protected String end;

        public Builder start(String start) {
            this.start = start;
            return this;
        }

        public Builder end(String end) {
            this.end = end;
            return this;
        }

        public AllocationPool build() {
            return new AllocationPool(this.start, this.end);
        }

        public Builder fromAllocationPool(AllocationPool in) {
            return this.start(in.getStart()).end(in.getEnd());
        }
    }
}

