/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import java.beans.ConstructorProperties;
import javax.inject.Named;
import org.jclouds.javax.annotation.Nullable;

public class BlockDeviceMapping {
    private String uuid;
    @Named(value="device_name")
    private String deviceName;
    @Named(value="device_type")
    private String deviceType;
    @Named(value="volume_size")
    private Integer volumeSize;
    @Named(value="source_type")
    private String sourceType;
    @Named(value="destination_type")
    private String destinationType;
    @Named(value="disk_bus")
    private String diskBus;
    @Named(value="no_device")
    private Boolean noDevice;
    @Named(value="guest_format")
    private String guestFormat;
    @Named(value="boot_index")
    private Integer bootIndex;
    @Named(value="delete_on_termination")
    private Boolean deleteOnTermination;

    @ConstructorProperties(value={"uuid", "device_name", "device_type", "volume_size", "source_type", "destination_type", "disk_bus", "no_device", "guest_format", "boot_index", "delete_on_termination"})
    protected BlockDeviceMapping(String uuid, String deviceName, String deviceType, Integer volumeSize, String sourceType, String destinationType, String diskBus, Boolean noDevice, String guestFormat, Integer bootIndex, Boolean deleteOnTermination) {
        this.uuid = uuid;
        this.deviceName = deviceName;
        this.deviceType = deviceType;
        this.volumeSize = volumeSize;
        this.sourceType = sourceType;
        this.destinationType = destinationType;
        this.diskBus = diskBus;
        this.noDevice = noDevice;
        this.guestFormat = guestFormat;
        this.bootIndex = bootIndex;
        this.deleteOnTermination = deleteOnTermination;
    }

    @Nullable
    public String getUuid() {
        return this.uuid;
    }

    @Nullable
    public String getDeviceName() {
        return this.deviceName;
    }

    @Nullable
    public String getDeviceType() {
        return this.deviceType;
    }

    @Nullable
    public Integer getVolumeSize() {
        return this.volumeSize;
    }

    @Nullable
    public String getSourceType() {
        return this.sourceType;
    }

    @Nullable
    public String getDestinationType() {
        return this.destinationType;
    }

    @Nullable
    public String getDiskBus() {
        return this.diskBus;
    }

    @Nullable
    public Boolean getNoDevice() {
        return this.noDevice;
    }

    @Nullable
    public String getGuestFormat() {
        return this.guestFormat;
    }

    @Nullable
    public Integer getBootIndex() {
        return this.bootIndex;
    }

    @Nullable
    public Boolean getDeleteOnTermination() {
        return this.deleteOnTermination;
    }

    public int hashCode() {
        return Objects.hashCode(this.uuid, this.deviceName, this.deviceType, this.volumeSize, this.sourceType, this.destinationType, this.diskBus, this.noDevice, this.guestFormat, this.bootIndex, this.deleteOnTermination);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BlockDeviceMapping that = (BlockDeviceMapping)BlockDeviceMapping.class.cast(obj);
        return Objects.equal(this.uuid, that.uuid) && Objects.equal(this.deviceName, that.deviceName) && Objects.equal(this.deviceType, that.deviceType) && Objects.equal(this.volumeSize, that.volumeSize) && Objects.equal(this.sourceType, that.sourceType) && Objects.equal(this.destinationType, that.destinationType) && Objects.equal(this.diskBus, that.diskBus) && Objects.equal(this.noDevice, that.noDevice) && Objects.equal(this.guestFormat, that.guestFormat) && Objects.equal(this.bootIndex, that.bootIndex) && Objects.equal(this.deleteOnTermination, that.deleteOnTermination);
    }

    protected MoreObjects.ToStringHelper string() {
        return MoreObjects.toStringHelper(this).add("uuid", this.uuid).add("deviceName", this.deviceName).add("deviceType", this.deviceType).add("volumeSize", this.volumeSize).add("sourceType", this.sourceType).add("destinationType", this.destinationType).add("diskBus", this.diskBus).add("noDevice", this.noDevice).add("guestFormat", this.guestFormat).add("bootIndex", this.bootIndex).add("deleteOnTermination", this.deleteOnTermination);
    }

    public String toString() {
        return this.string().toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return BlockDeviceMapping.builder().fromBlockDeviceMapping(this);
    }

    public static class Builder {
        protected String uuid;
        protected String deviceName;
        protected String deviceType;
        protected Integer volumeSize;
        protected String sourceType;
        protected String destinationType;
        protected String diskBus;
        protected Boolean noDevice;
        protected String guestFormat;
        protected Integer bootIndex;
        protected Boolean deleteOnTermination;

        public Builder uuid(String uuid) {
            this.uuid = uuid;
            return this;
        }

        public Builder deviceName(String deviceName) {
            this.deviceName = deviceName;
            return this;
        }

        public Builder deviceType(String deviceType) {
            this.deviceType = deviceType;
            return this;
        }

        public Builder volumeSize(Integer volumeSize) {
            this.volumeSize = volumeSize;
            return this;
        }

        public Builder sourceType(String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        public Builder destinationType(String destinationType) {
            this.destinationType = destinationType;
            return this;
        }

        public Builder diskBus(String diskBus) {
            this.diskBus = diskBus;
            return this;
        }

        public Builder noDevice(Boolean noDevice) {
            this.noDevice = noDevice;
            return this;
        }

        public Builder guestFormat(String guestFormat) {
            this.guestFormat = guestFormat;
            return this;
        }

        public Builder bootIndex(Integer bootIndex) {
            this.bootIndex = bootIndex;
            return this;
        }

        public Builder deleteOnTermination(Boolean deleteOnTermination) {
            this.deleteOnTermination = deleteOnTermination;
            return this;
        }

        public BlockDeviceMapping build() {
            return new BlockDeviceMapping(this.uuid, this.deviceName, this.deviceType, this.volumeSize, this.sourceType, this.destinationType, this.diskBus, this.noDevice, this.guestFormat, this.bootIndex, this.deleteOnTermination);
        }

        public Builder fromBlockDeviceMapping(BlockDeviceMapping in) {
            return this.uuid(in.getUuid()).deviceName(in.getDeviceName()).deviceType(in.getDeviceType()).volumeSize(in.getVolumeSize()).sourceType(in.getSourceType()).destinationType(in.getDestinationType()).diskBus(in.getDiskBus()).noDevice(in.getNoDevice()).bootIndex(in.getBootIndex()).deleteOnTermination(in.getDeleteOnTermination()).guestFormat(in.getGuestFormat());
        }
    }
}

