/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.options;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ForwardingObject;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.io.BaseEncoding;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import org.jclouds.http.HttpRequest;
import org.jclouds.openstack.nova.v2_0.domain.BlockDeviceMapping;
import org.jclouds.openstack.nova.v2_0.domain.Network;
import org.jclouds.rest.MapBinder;
import org.jclouds.rest.binders.BindToJsonPayload;

public class CreateServerOptions
implements MapBinder {
    @Inject
    private BindToJsonPayload jsonBinder;
    private String keyName;
    private String adminPass;
    private Set<String> securityGroupNames = ImmutableSet.of();
    private Map<String, String> metadata = ImmutableMap.of();
    private List<File> personality = Lists.newArrayList();
    private byte[] userData;
    private String diskConfig;
    private List<String> networks = ImmutableList.of();
    private List<Network> novaNetworks = ImmutableList.of();
    private String availabilityZone;
    private boolean configDrive;
    private Set<BlockDeviceMapping> blockDeviceMappings = ImmutableSet.of();

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof CreateServerOptions) {
            CreateServerOptions other = (CreateServerOptions)CreateServerOptions.class.cast(object);
            return Objects.equal(this.keyName, other.keyName) && Objects.equal(this.adminPass, other.adminPass) && Objects.equal(this.securityGroupNames, other.securityGroupNames) && Objects.equal(this.metadata, other.metadata) && Objects.equal(this.personality, other.personality) && Objects.equal(this.diskConfig, other.diskConfig) && Objects.equal(this.networks, other.networks) && Objects.equal(this.availabilityZone, other.availabilityZone) && Objects.equal(this.configDrive, other.configDrive) && Objects.equal(this.blockDeviceMappings, other.blockDeviceMappings);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.keyName, this.adminPass, this.securityGroupNames, this.metadata, this.personality, this.networks, this.availabilityZone, this.configDrive, this.blockDeviceMappings);
    }

    protected String formatPossiblyGzipped(byte[] data) {
        if (data.length > 10 && data[0] == 31 && data[1] == -117) {
            return String.format("<gzipped data (%d bytes)>", data.length);
        }
        return new String(data);
    }

    protected MoreObjects.ToStringHelper string() {
        MoreObjects.ToStringHelper toString = MoreObjects.toStringHelper(this);
        toString.add("keyName", this.keyName);
        if (!this.securityGroupNames.isEmpty()) {
            toString.add("securityGroupNames", this.securityGroupNames);
        }
        if (!this.metadata.isEmpty()) {
            toString.add("metadata", this.metadata);
        }
        if (!this.personality.isEmpty()) {
            toString.add("personality", this.personality);
        }
        if (this.adminPass != null) {
            toString.add("adminPassPresent", true);
        }
        if (this.diskConfig != null) {
            toString.add("diskConfig", this.diskConfig);
        }
        toString.add("userData", this.userData == null ? null : this.formatPossiblyGzipped(this.userData));
        if (!this.networks.isEmpty()) {
            toString.add("networks", this.networks);
        }
        toString.add("availabilityZone", this.availabilityZone == null ? null : this.availabilityZone);
        toString.add("configDrive", this.configDrive);
        if (!this.blockDeviceMappings.isEmpty()) {
            toString.add("blockDeviceMappings", this.blockDeviceMappings);
        }
        return toString;
    }

    public String toString() {
        return this.string().toString();
    }

    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Map<String, Object> postParams) {
        ServerRequest server = new ServerRequest(Preconditions.checkNotNull(postParams.get("name"), "name parameter not present").toString(), Preconditions.checkNotNull(postParams.get("imageRef"), "imageRef parameter not present").toString(), Preconditions.checkNotNull(postParams.get("flavorRef"), "flavorRef parameter not present").toString());
        if (!this.metadata.isEmpty()) {
            server.metadata = this.metadata;
        }
        if (!this.personality.isEmpty()) {
            server.personality = this.personality;
        }
        if (this.keyName != null) {
            server.key_name = this.keyName;
        }
        if (this.availabilityZone != null) {
            server.availabilityZone = this.availabilityZone;
        }
        if (this.userData != null) {
            server.user_data = BaseEncoding.base64().encode(this.userData);
        }
        if (this.configDrive) {
            server.configDrive = "true";
        }
        if (!this.securityGroupNames.isEmpty()) {
            server.securityGroupNames = Sets.newLinkedHashSet();
            for (String string : this.securityGroupNames) {
                server.securityGroupNames.add(new NamedThingy(string));
            }
        }
        if (this.adminPass != null) {
            server.adminPass = this.adminPass;
        }
        if (this.diskConfig != null) {
            server.diskConfig = this.diskConfig;
        }
        if (!this.networks.isEmpty() || !this.novaNetworks.isEmpty()) {
            server.networks = Lists.newArrayList();
            for (Network network : this.novaNetworks) {
                ImmutableMap.Builder<String, String> networkMap = new ImmutableMap.Builder<String, String>();
                if (network.getNetworkUuid() != null) {
                    networkMap.put("uuid", network.getNetworkUuid());
                }
                if (network.getPortUuid() != null) {
                    networkMap.put("port", network.getPortUuid());
                }
                if (network.getFixedIp() != null) {
                    networkMap.put("fixed_ip", network.getFixedIp());
                }
                server.networks.add(networkMap.build());
            }
            for (String string : this.networks) {
                server.networks.add(ImmutableMap.of("uuid", string));
            }
        }
        if (!this.blockDeviceMappings.isEmpty()) {
            server.blockDeviceMappings = this.blockDeviceMappings;
        }
        return this.bindToRequest(request, ImmutableMap.of("server", server));
    }

    public CreateServerOptions writeFileToPath(byte[] contents, String path) {
        this.personality.add(new File(path, contents));
        return this;
    }

    public CreateServerOptions adminPass(String adminPass) {
        Preconditions.checkNotNull(adminPass, "adminPass");
        this.adminPass = adminPass;
        return this;
    }

    public CreateServerOptions metadata(Map<String, String> metadata) {
        Preconditions.checkNotNull(metadata, "metadata");
        for (Map.Entry<String, String> entry : metadata.entrySet()) {
            Preconditions.checkArgument(entry.getKey().getBytes().length < 255, String.format("maximum length of metadata key is 255 bytes.  Key specified %s is %d bytes", entry.getKey(), entry.getKey().getBytes().length));
            Preconditions.checkArgument(entry.getKey().getBytes().length < 255, String.format("maximum length of metadata value is 255 bytes.  Value specified for %s (%s) is %d bytes", entry.getKey(), entry.getValue(), entry.getValue().getBytes().length));
        }
        this.metadata = ImmutableMap.copyOf(metadata);
        return this;
    }

    public CreateServerOptions userData(byte[] userData) {
        this.userData = userData;
        return this;
    }

    public CreateServerOptions configDrive(boolean configDrive) {
        this.configDrive = configDrive;
        return this;
    }

    public CreateServerOptions keyPairName(String keyName) {
        this.keyName = keyName;
        return this;
    }

    public CreateServerOptions availabilityZone(String availabilityZone) {
        this.availabilityZone = availabilityZone;
        return this;
    }

    public CreateServerOptions securityGroupNames(String ... securityGroupNames) {
        return this.securityGroupNames(ImmutableSet.copyOf(Preconditions.checkNotNull(securityGroupNames, "securityGroupNames")));
    }

    public CreateServerOptions securityGroupNames(Iterable<String> securityGroupNames) {
        for (String groupName : Preconditions.checkNotNull(securityGroupNames, "securityGroupNames")) {
            Preconditions.checkNotNull(Strings.emptyToNull(groupName), "all security groups must be non-empty");
        }
        this.securityGroupNames = ImmutableSet.copyOf(securityGroupNames);
        return this;
    }

    public CreateServerOptions diskConfig(String diskConfig) {
        this.diskConfig = diskConfig;
        return this;
    }

    public CreateServerOptions networks(Iterable<String> networks) {
        this.networks = ImmutableList.copyOf(networks);
        return this;
    }

    public CreateServerOptions novaNetworks(Iterable<Network> networks) {
        this.novaNetworks = ImmutableList.copyOf(networks);
        return this;
    }

    public CreateServerOptions networks(String ... networks) {
        return this.networks(ImmutableList.copyOf(networks));
    }

    public CreateServerOptions blockDeviceMappings(Set<BlockDeviceMapping> blockDeviceMappings) {
        this.blockDeviceMappings = ImmutableSet.copyOf(blockDeviceMappings);
        return this;
    }

    public String getKeyPairName() {
        return this.keyName;
    }

    public String getAvailabilityZone() {
        return this.availabilityZone;
    }

    public Set<String> getSecurityGroupNames() {
        return this.securityGroupNames;
    }

    public List<String> getNetworks() {
        return this.networks;
    }

    public List<Network> getNovaNetworks() {
        return this.novaNetworks;
    }

    public String getDiskConfig() {
        return this.diskConfig;
    }

    public boolean getConfigDrive() {
        return this.configDrive;
    }

    public Set<BlockDeviceMapping> getBlockDeviceMappings() {
        return this.blockDeviceMappings;
    }

    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        return this.jsonBinder.bindToRequest(request, input);
    }

    public static class Builder {
        public static CreateServerOptions writeFileToPath(byte[] contents, String path) {
            CreateServerOptions options = new CreateServerOptions();
            return options.writeFileToPath(contents, path);
        }

        public static CreateServerOptions adminPass(String adminPass) {
            CreateServerOptions options = new CreateServerOptions();
            return options.adminPass(adminPass);
        }

        public static CreateServerOptions metadata(Map<String, String> metadata) {
            CreateServerOptions options = new CreateServerOptions();
            return options.metadata(metadata);
        }

        public static CreateServerOptions keyPairName(String keyName) {
            CreateServerOptions options = new CreateServerOptions();
            return options.keyPairName(keyName);
        }

        public static CreateServerOptions securityGroupNames(String ... groupNames) {
            CreateServerOptions options = new CreateServerOptions();
            if (new CreateServerOptions().securityGroupNames(groupNames) == CreateServerOptions.class.cast(options.securityGroupNames(groupNames))) {
                System.out.println("They are fucking equal, dump the cast!!!");
            }
            return (CreateServerOptions)CreateServerOptions.class.cast(options.securityGroupNames(groupNames));
        }

        public static CreateServerOptions securityGroupNames(Iterable<String> groupNames) {
            return (CreateServerOptions)CreateServerOptions.class.cast(new CreateServerOptions().securityGroupNames(groupNames));
        }

        public static CreateServerOptions diskConfig(String diskConfig) {
            return (CreateServerOptions)CreateServerOptions.class.cast(new CreateServerOptions().diskConfig(diskConfig));
        }

        public static CreateServerOptions networks(String ... networks) {
            return (CreateServerOptions)CreateServerOptions.class.cast(new CreateServerOptions().networks(networks));
        }

        public static CreateServerOptions networks(Iterable<String> networks) {
            return (CreateServerOptions)CreateServerOptions.class.cast(new CreateServerOptions().networks(networks));
        }

        public static CreateServerOptions novaNetworks(Iterable<Network> networks) {
            return (CreateServerOptions)CreateServerOptions.class.cast(new CreateServerOptions().novaNetworks(networks));
        }

        public static CreateServerOptions availabilityZone(String availabilityZone) {
            return new CreateServerOptions().availabilityZone(availabilityZone);
        }

        public static CreateServerOptions blockDeviceMappings(Set<BlockDeviceMapping> blockDeviceMappings) {
            return new CreateServerOptions().blockDeviceMappings(blockDeviceMappings);
        }
    }

    private static class NamedThingy
    extends ForwardingObject {
        private String name;

        private NamedThingy(String name) {
            this.name = name;
        }

        @Override
        protected Object delegate() {
            return this.name;
        }
    }

    static class ServerRequest {
        final String name;
        final String imageRef;
        final String flavorRef;
        @Named(value="availability_zone")
        String availabilityZone;
        String adminPass;
        Map<String, String> metadata;
        List<File> personality;
        String key_name;
        @Named(value="security_groups")
        Set<NamedThingy> securityGroupNames;
        String user_data;
        @Named(value="OS-DCF:diskConfig")
        String diskConfig;
        List<Map<String, String>> networks;
        @Named(value="config_drive")
        String configDrive;
        @Named(value="block_device_mapping_v2")
        Set<BlockDeviceMapping> blockDeviceMappings;

        private ServerRequest(String name, String imageRef, String flavorRef) {
            this.name = name;
            this.imageRef = imageRef;
            this.flavorRef = flavorRef;
        }
    }

    static class File {
        private final String path;
        private final String contents;

        public File(String path, byte[] contents) {
            this.path = Preconditions.checkNotNull(path, "path");
            this.contents = BaseEncoding.base64().encode(Preconditions.checkNotNull(contents, "contents"));
            Preconditions.checkArgument(path.getBytes().length < 255, String.format("maximum length of path is 255 bytes.  Path specified %s is %d bytes", path, path.getBytes().length));
        }

        public String getContents() {
            return this.contents;
        }

        public String getPath() {
            return this.path;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof File) {
                File other = (File)File.class.cast(object);
                return Objects.equal(this.path, other.path);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hashCode(this.path);
        }

        public String toString() {
            return MoreObjects.toStringHelper("file").add("path", this.path).toString();
        }
    }
}

