/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.packet.compute.strategy;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.compute.config.CustomizationResponse;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.functions.GroupNamingConvention;
import org.jclouds.compute.strategy.CreateNodeWithGroupEncodedIntoName;
import org.jclouds.compute.strategy.CustomizeNodeAndAddToGoodMapOrPutExceptionIntoBadMap;
import org.jclouds.compute.strategy.ListNodesStrategy;
import org.jclouds.compute.strategy.impl.CreateNodesWithGroupEncodedIntoNameThenAddToSet;
import org.jclouds.logging.Logger;
import org.jclouds.packet.PacketApi;
import org.jclouds.packet.compute.options.PacketTemplateOptions;
import org.jclouds.packet.domain.SshKey;
import org.jclouds.ssh.SshKeyPairGenerator;
import org.jclouds.ssh.SshKeys;

@Singleton
public class CreateSshKeysThenCreateNodes
extends CreateNodesWithGroupEncodedIntoNameThenAddToSet {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    private final PacketApi api;
    private final SshKeyPairGenerator keyGenerator;

    @Inject
    protected CreateSshKeysThenCreateNodes(CreateNodeWithGroupEncodedIntoName addNodeWithGroupStrategy, ListNodesStrategy listNodesStrategy, GroupNamingConvention.Factory namingConvention, @Named(value="jclouds.user-threads") ListeningExecutorService userExecutor, CustomizeNodeAndAddToGoodMapOrPutExceptionIntoBadMap.Factory customizeNodeAndAddToGoodMapOrPutExceptionIntoBadMapFactory, PacketApi api, SshKeyPairGenerator keyGenerator) {
        super(addNodeWithGroupStrategy, listNodesStrategy, namingConvention, userExecutor, customizeNodeAndAddToGoodMapOrPutExceptionIntoBadMapFactory);
        this.api = api;
        this.keyGenerator = keyGenerator;
    }

    @Override
    public Map<?, ListenableFuture<Void>> execute(String group, int count, Template template, Set<NodeMetadata> goodNodes, Map<NodeMetadata, Exception> badNodes, Multimap<NodeMetadata, CustomizationResponse> customizationResponses) {
        PacketTemplateOptions options = template.getOptions().as(PacketTemplateOptions.class);
        HashSet<String> generatedSshKeyIds = Sets.newHashSet();
        if (Strings.isNullOrEmpty(options.getPublicKey())) {
            this.generateKeyPairAndAddKeyToSet(options, generatedSshKeyIds, group);
        }
        if (options.getRunScript() != null && Strings.isNullOrEmpty(options.getLoginPrivateKey())) {
            this.logger.warn(">> A runScript has been configured but no SSH key has been provided. Authentication will delegate to the ssh-agent", new Object[0]);
        }
        if (!Strings.isNullOrEmpty(options.getPublicKey())) {
            this.createKeyPairForPublicKeyInOptionsAndAddToSet(options, generatedSshKeyIds);
        }
        Map<?, ListenableFuture<Void>> responses = super.execute(group, count, template, goodNodes, badNodes, customizationResponses);
        this.registerAutoGeneratedKeyPairCleanupCallbacks(responses, generatedSshKeyIds);
        return responses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createKeyPairForPublicKeyInOptionsAndAddToSet(PacketTemplateOptions options, Set<String> generatedSshKeyIds) {
        this.logger.debug(">> checking if the key pair already exists...", new Object[0]);
        PublicKey userKey = CreateSshKeysThenCreateNodes.readPublicKey(options.getPublicKey());
        final String fingerprint = CreateSshKeysThenCreateNodes.computeFingerprint(userKey);
        Class<CreateSshKeysThenCreateNodes> clazz = CreateSshKeysThenCreateNodes.class;
        synchronized (CreateSshKeysThenCreateNodes.class) {
            boolean keyExists = this.api.sshKeyApi().list().concat().anyMatch(new Predicate<SshKey>(){

                @Override
                public boolean apply(SshKey input) {
                    return input.fingerprint().equals(fingerprint);
                }
            });
            if (!keyExists) {
                this.logger.debug(">> key pair not found. creating a new key pair %s ...", fingerprint);
                SshKey newKey = this.api.sshKeyApi().create(fingerprint, options.getPublicKey());
                this.logger.debug(">> key pair created! %s", newKey);
                generatedSshKeyIds.add(newKey.id());
            } else {
                this.logger.debug(">> key pair found for key %s", fingerprint);
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    private static PublicKey readPublicKey(String publicKey) {
        Iterable<String> parts = Splitter.on(' ').split(publicKey);
        Preconditions.checkArgument(Iterables.size(parts) >= 2, "bad format, should be: ssh-rsa AAAAB3...");
        String type = Iterables.get(parts, 0);
        try {
            if ("ssh-rsa".equals(type)) {
                RSAPublicKeySpec spec = SshKeys.publicKeySpecFromOpenSSH(publicKey);
                return KeyFactory.getInstance("RSA").generatePublic(spec);
            }
            throw new IllegalArgumentException("bad format, ssh-rsa is only supported");
        }
        catch (InvalidKeySpecException ex) {
            throw Throwables.propagate(ex);
        }
        catch (NoSuchAlgorithmException ex) {
            throw Throwables.propagate(ex);
        }
    }

    private void generateKeyPairAndAddKeyToSet(PacketTemplateOptions options, Set<String> generatedSshKeyIds, String prefix) {
        this.logger.debug(">> creating default keypair for node...", new Object[0]);
        Map defaultKeys = (Map)this.keyGenerator.get();
        SshKey sshKey = this.api.sshKeyApi().create(this.namingConvention.create().uniqueNameForGroup(prefix), (String)defaultKeys.get("public"));
        generatedSshKeyIds.add(sshKey.id());
        this.logger.debug(">> keypair created! %s", sshKey);
        if (Strings.isNullOrEmpty(options.getLoginPrivateKey())) {
            options.overrideLoginPrivateKey((String)defaultKeys.get("private"));
        }
    }

    private void registerAutoGeneratedKeyPairCleanupCallbacks(Map<?, ListenableFuture<Void>> responses, final Set<String> generatedSshKeyIds) {
        ListenableFuture<List<Void>> aggregatedResponses = Futures.successfulAsList(responses.values());
        Futures.addCallback(aggregatedResponses, new FutureCallback<List<Void>>(){

            @Override
            public void onSuccess(List<Void> result) {
                this.cleanupAutoGeneratedKeyPairs(generatedSshKeyIds);
            }

            @Override
            public void onFailure(Throwable t) {
                this.cleanupAutoGeneratedKeyPairs(generatedSshKeyIds);
            }

            private void cleanupAutoGeneratedKeyPairs(Set<String> generatedSshKeyIds2) {
                CreateSshKeysThenCreateNodes.this.logger.debug(">> cleaning up auto-generated key pairs...", new Object[0]);
                for (String sshKeyId : generatedSshKeyIds2) {
                    try {
                        CreateSshKeysThenCreateNodes.this.api.sshKeyApi().delete(sshKeyId);
                    }
                    catch (Exception ex) {
                        CreateSshKeysThenCreateNodes.this.logger.warn(">> could not delete key pair %s: %s", sshKeyId, ex.getMessage());
                    }
                }
            }
        }, this.userExecutor);
    }

    private static String computeFingerprint(PublicKey key) {
        if (key instanceof RSAPublicKey) {
            RSAPublicKey rsaKey = (RSAPublicKey)key;
            return SshKeys.fingerprint(rsaKey.getPublicExponent(), rsaKey.getModulus());
        }
        throw new IllegalArgumentException("Only RSA keys are supported");
    }
}

