/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.conn.slurm;

import es.bsc.conn.Connector;
import es.bsc.conn.clients.exceptions.ConnClientException;
import es.bsc.conn.clients.slurm.JobDescription;
import es.bsc.conn.clients.slurm.SlurmClient;
import es.bsc.conn.exceptions.ConnException;
import es.bsc.conn.types.HardwareDescription;
import es.bsc.conn.types.InstallationDescription;
import es.bsc.conn.types.Processor;
import es.bsc.conn.types.SoftwareDescription;
import es.bsc.conn.types.VirtualResource;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SLURMConnector
extends Connector {
    private static final String RUNNING = "RUNNING";
    private static final String FAILED = "FAILED";
    private static final long POLLING_INTERVAL = 5L;
    private static final int TIMEOUT = 1800;
    private static final String JOB_STATE = "JobState";
    private static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Connectors.Conn.SLURM");
    private SlurmClient client;
    private String network;
    private final Map<String, HardwareDescription> vmidToHardwareRequest = new HashMap<String, HardwareDescription>();
    private final Map<String, SoftwareDescription> vmidToSoftwareRequest = new HashMap<String, SoftwareDescription>();
    private final Map<String, String> vmidToHostName = new HashMap<String, String>();
    private int currentNodes;
    private String logDir;

    public SLURMConnector(Map<String, String> props) throws ConnException {
        super(props);
        String appLogdir = System.getProperty("compss.appLogDir");
        if (appLogdir == null) {
            throw new ConnException("[Connector] Unable to get app log dir");
        }
        File f = new File(appLogdir + File.separator + "slurm-conn-log");
        if (!f.mkdirs()) {
            throw new ConnException(" [Connector] Unable to create SLURM connector log dir");
        }
        this.logDir = f.getAbsolutePath();
        String masterName = props.get("master_name");
        if (masterName == null || masterName.isEmpty()) {
            throw new ConnException(" [Connector] Unable to get master_name. Property is empty");
        }
        boolean ssh = false;
        String sshStr = props.get("slurm_over_ssh");
        if (sshStr != null && !sshStr.isEmpty()) {
            ssh = Boolean.parseBoolean(sshStr);
        }
        boolean expand = true;
        String expandStr = props.get("expand_job");
        if (expandStr != null && !expandStr.isEmpty()) {
            expand = Boolean.parseBoolean(expandStr);
        }
        LOGGER.debug("[Connector] Starting Slurm client for master in " + masterName + ", ssh " + ssh + " and expand " + expand);
        this.client = new SlurmClient(masterName, ssh, expand);
        this.network = props.get("network");
        if (this.network == null) {
            this.network = "";
        }
        this.currentNodes = 0;
    }

    @Override
    public Object create(HardwareDescription hd, SoftwareDescription sd, Map<String, String> prop) throws ConnException {
        try {
            String jobName = this.appName + '-' + UUID.randomUUID().toString();
            ++this.currentNodes;
            String jobId = this.client.createCompute(this.generateJobDescription(hd, sd), this.generateExecScript(jobName, hd, sd, prop));
            this.vmidToHardwareRequest.put(jobId, hd);
            this.vmidToSoftwareRequest.put(jobId, sd);
            VirtualResource vr = new VirtualResource(jobId, hd, sd, prop);
            return vr.getId();
        }
        catch (ConnClientException ce) {
            LOGGER.error("[Connector] Exception submitting job for creation", (Throwable)ce);
            --this.currentNodes;
            throw new ConnException(ce);
        }
        catch (Exception e) {
            LOGGER.error("[Connector] Exception submitting job for node creation", (Throwable)e);
            throw new ConnException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String generateExecScript(String jobName, HardwareDescription hd, SoftwareDescription sd, Map<String, String> prop) throws ConnException {
        String stdFlags = this.generateFlags(jobName, prop);
        InstallationDescription instDesc = sd.getInstallation();
        StringBuilder script = new StringBuilder("#!/bin/sh\n");
        String launch_command = prop.get("launch_command");
        if (launch_command != null && !launch_command.isEmpty()) {
            LOGGER.debug("[Connector] Adding launch command to the run script");
            script.append(launch_command + "$SLURM_JOB_NODELIST ");
        } else {
            LOGGER.debug("[Connector] launch command not found");
        }
        String installDir = instDesc.getInstallDir();
        if (installDir == null && (installDir = System.getenv("COMPSS_HOME")) == null) {
            throw new ConnException("[Connector] Unable to get COMPSs installation directory");
        }
        if (hd.getImageName() != null && !hd.getImageName().isEmpty() && !"None".equals(hd.getImageName())) {
            script.append("singularity exec ");
            String containerOpts = prop.get("container_opts");
            if (containerOpts != null && !containerOpts.isEmpty()) {
                script.append(containerOpts + " ");
            }
            script.append(hd.getImageName() + " " + installDir + "/Runtime/scripts/system/adaptors/nio/persistent_worker_starter.sh");
        } else {
            script.append(installDir + "/Runtime/scripts/system/adaptors/nio/persistent_worker_starter.sh");
        }
        String libPath = instDesc.getLibraryPath();
        if (libPath == null || libPath.isEmpty()) {
            libPath = this.getPWD();
        }
        script.append(" " + libPath);
        String appDir = instDesc.getAppDir();
        if (appDir == null || appDir.isEmpty()) {
            appDir = this.getPWD();
        }
        script.append(" " + appDir);
        String cp = instDesc.getClasspath();
        if (cp == null || cp.isEmpty()) {
            cp = this.getPWD();
        }
        script.append(" " + cp);
        String jvmOptsSize = prop.get("jvm_opts_size");
        if (jvmOptsSize == null || jvmOptsSize.isEmpty()) {
            jvmOptsSize = "0";
        }
        script.append(" " + jvmOptsSize);
        String jvmOptsStr = prop.get("jvm_opts_str");
        if (jvmOptsStr == null) {
            jvmOptsStr = "";
        }
        script.append(" " + jvmOptsStr);
        String fpgaArgsSize = prop.get("fpga_reprogram_size");
        if (fpgaArgsSize == null || fpgaArgsSize.isEmpty()) {
            fpgaArgsSize = "0";
        }
        script.append(" " + fpgaArgsSize);
        String fpgaArgsStr = prop.get("fpga_reprogram_str");
        if (fpgaArgsStr == null) {
            fpgaArgsStr = "";
        }
        script.append(" " + fpgaArgsStr);
        String workerDebug = prop.get("worker_debug");
        if (workerDebug == null || workerDebug.isEmpty() || "null".equals(workerDebug)) {
            workerDebug = "false";
        }
        script.append(" " + workerDebug);
        script.append(" 5");
        script.append(" 5");
        script.append(" $SLURM_JOB_NODELIST" + this.network);
        script.append(" 43001");
        String masterPort = prop.get("master_port");
        if (masterPort == null || masterPort.isEmpty() || "null".equals(masterPort)) {
            masterPort = "43000";
        }
        script.append(" " + masterPort);
        script.append(" " + hd.getTotalCPUComputingUnits());
        script.append(" " + hd.getTotalGPUComputingUnits());
        script.append(" " + hd.getTotalFPGAComputingUnits());
        String cpuAff = prop.get("cpu_affinity");
        if (cpuAff == null || cpuAff.isEmpty() || "null".equals(cpuAff)) {
            cpuAff = "automatic";
        }
        script.append(" " + cpuAff);
        String gpuAff = prop.get("gpu_affinity");
        if (gpuAff == null || gpuAff.isEmpty() || "null".equals(gpuAff)) {
            gpuAff = "automatic";
        }
        script.append(" " + gpuAff);
        String fpgaAff = prop.get("fpga_affinity");
        if (fpgaAff == null || fpgaAff.isEmpty() || "null".equals(fpgaAff)) {
            fpgaAff = "automatic";
        }
        script.append(" " + fpgaAff);
        int limitOfTasks = instDesc.getLimitOfTasks();
        if (limitOfTasks < 0) {
            limitOfTasks = hd.getTotalCPUComputingUnits();
        }
        script.append(" " + limitOfTasks);
        String uuid = System.getProperty("compss.uuid");
        if (uuid == null) throw new ConnException("Unable to get uuid");
        if (uuid.isEmpty()) throw new ConnException("Unable to get uuid");
        if ("null".equals(uuid)) {
            throw new ConnException("Unable to get uuid");
        }
        script.append(" " + uuid);
        String lang = System.getProperty("compss.lang");
        if (lang == null) throw new ConnException("Unable to get lang");
        if (lang.isEmpty()) throw new ConnException("Unable to get lang");
        if ("null".equals(lang)) {
            throw new ConnException("Unable to get lang");
        }
        script.append(" " + lang);
        script.append(" " + instDesc.getWorkingDir() + File.separator + uuid + File.separator + "$SLURM_JOB_NODELIST" + this.network);
        script.append(" " + installDir);
        script.append(" " + appDir);
        script.append(" " + libPath);
        script.append(" " + cp);
        String pythonPath = instDesc.getPythonPath();
        if (pythonPath == null || pythonPath.isEmpty()) {
            pythonPath = this.getPWD();
        }
        script.append(" " + pythonPath);
        String tracing = System.getProperty("compss.tracing");
        if (tracing == null || tracing.isEmpty() || "null".equals(tracing)) {
            tracing = "0";
        }
        script.append(" " + tracing);
        String extraeFile = System.getProperty("compss.extrae.file");
        if (extraeFile == null || extraeFile.isEmpty() || "null".equals(extraeFile)) {
            extraeFile = "null";
        }
        script.append(" " + extraeFile);
        script.append(" " + (this.client.getInitialNodes() + this.currentNodes));
        String storageConf = System.getProperty("compss.storage.conf");
        if (storageConf == null || storageConf.isEmpty() || "null".equals(storageConf)) {
            storageConf = "null";
        }
        script.append(" " + storageConf);
        String executionType = System.getProperty("compss.task.execution");
        if (executionType == null || executionType.isEmpty() || "null".equals(executionType)) {
            executionType = "compss";
        }
        script.append(" " + executionType);
        String persistentC = System.getProperty("compss.worker.persistent.c");
        if (persistentC == null || persistentC.isEmpty() || "null".equals(persistentC)) {
            persistentC = "false";
        }
        script.append(" " + persistentC);
        String pythonInterpreter = System.getProperty("compss.python.interpreter");
        if (pythonInterpreter == null || pythonInterpreter.isEmpty() || "null".equals(pythonInterpreter)) {
            pythonInterpreter = "python";
        }
        script.append(" " + pythonInterpreter);
        String pythonVersion = System.getProperty("compss.python.interpreter");
        if (pythonVersion == null || pythonVersion.isEmpty() || "null".equals(pythonVersion)) {
            pythonVersion = "2";
        }
        script.append(" " + pythonVersion);
        String pythonEnv = System.getProperty("compss.python.virtualenvironment");
        if (pythonEnv == null || pythonEnv.isEmpty()) {
            pythonEnv = "null";
        }
        script.append(" " + pythonEnv);
        String pythonPropagateEnv = System.getProperty("compss.python.propagate_virtualenvironment");
        if (pythonPropagateEnv == null || pythonPropagateEnv.isEmpty() || "null".equals(pythonPropagateEnv)) {
            pythonPropagateEnv = "true";
        }
        script.append(" " + pythonPropagateEnv);
        File runScript = new File(this.logDir + File.separator + "run_" + jobName);
        try {
            if (!runScript.createNewFile()) {
                throw new IOException("[Connector] ERROR: File already exists");
            }
            if (!runScript.setExecutable(true)) {
                throw new IOException("[Connector] ERROR: Cannot make the file executable");
            }
        }
        catch (IOException ioe) {
            throw new ConnException("[Connector] Exception creating script", ioe);
        }
        try (FileOutputStream fos = new FileOutputStream(runScript);){
            fos.write(script.toString().getBytes());
            String string = stdFlags + " " + runScript.getAbsolutePath();
            return string;
        }
        catch (IOException e) {
            throw new ConnException("[Connector] Exception writting script", e);
        }
    }

    private String generateFlags(String jobName, Map<String, String> prop) {
        String constraint;
        String qos;
        String reservation;
        StringBuilder flags = new StringBuilder("-e " + this.logDir + File.separator + jobName + ".err -o " + this.logDir + File.separator + jobName + ".out");
        String queue = prop.get("queue");
        if (queue != null && !queue.isEmpty()) {
            flags.append(" -p " + queue);
        }
        if ((reservation = prop.get("reservation")) != null && !reservation.isEmpty()) {
            flags.append(" --reservation=" + reservation);
        }
        if ((qos = prop.get("qos")) != null && !qos.isEmpty()) {
            flags.append(" --qos=" + qos);
        }
        if ((constraint = prop.get("constraint")) != null && !constraint.isEmpty()) {
            flags.append(" --constraint=" + constraint);
        }
        return flags.toString();
    }

    private String getPWD() throws ConnException {
        String pwd = System.getenv("PWD");
        if (pwd == null) {
            throw new ConnException("[Connector] Unable to get PWD directory");
        }
        return pwd;
    }

    private JobDescription generateJobDescription(HardwareDescription hd, SoftwareDescription sd) {
        HashMap<String, String> req = new HashMap<String, String>();
        req.put("NumNodes", "1");
        req.put("NumCPUs", Integer.toString(hd.getTotalCPUComputingUnits()));
        if (hd.getMemorySize() > 0.0f) {
            req.put("mem", Integer.toString((int)hd.getMemorySize() * 1024));
        }
        int gpuUnits = 0;
        for (Processor p : hd.getProcessors()) {
            if (!"GPU".equals(p.getArchitecture())) continue;
            gpuUnits += p.getComputingUnits();
        }
        if (gpuUnits > 0) {
            req.put("Gres", Integer.toString(gpuUnits));
        }
        return new JobDescription(req);
    }

    @Override
    public VirtualResource waitUntilCreation(Object id) throws ConnException {
        LOGGER.debug("[Connector] Waiting for resource creation " + id);
        String jobId = (String)id;
        LOGGER.debug("[Connector] Waiting until node of job " + jobId + " is created");
        try {
            JobDescription jd = this.client.getJobDescription(jobId);
            LOGGER.debug("[Connector] Job State is " + jd.getProperty(JOB_STATE));
            int tries = 0;
            while (jd.getProperty(JOB_STATE) == null || !jd.getProperty(JOB_STATE).equals(RUNNING)) {
                if (jd.getProperty(JOB_STATE).equals(FAILED)) {
                    LOGGER.error("[Connector] Error waiting for VM Creation. Middleware has return an error state");
                    throw new ConnException("[Connector] Error waiting for VM Creation. Middleware has return an error state");
                }
                if ((long)tries * 5L > 1800L) {
                    this.client.cancelJob(jobId);
                    this.vmidToHardwareRequest.remove(jobId);
                    this.vmidToSoftwareRequest.remove(jobId);
                    throw new ConnException("[Connector] Maximum Job creation time reached.");
                }
                ++tries;
                Thread.sleep(5000L);
                jd = this.client.getJobDescription(jobId);
                LOGGER.debug("[Connector] Job State is " + jd.getProperty(JOB_STATE));
            }
            this.client.addNodesToMain(jobId, jd);
            VirtualResource vr = new VirtualResource();
            vr.setId(jobId);
            String resourceName = jd.getNodeList().get(0) + this.network;
            LOGGER.debug("[Connector] Setting resource ip: " + resourceName);
            this.vmidToHostName.put(jobId, resourceName);
            vr.setIp(resourceName);
            vr.setProperties(null);
            HardwareDescription hd = this.vmidToHardwareRequest.get(jobId);
            if (hd == null) {
                throw new ConnException("[Connector] Unregistered hardware description for job " + jobId);
            }
            vr.setHd(hd);
            SoftwareDescription sd = this.vmidToSoftwareRequest.get(jobId);
            if (sd == null) {
                throw new ConnException("[Connector] Unregistered software description for job " + jobId);
            }
            sd.setOperatingSystemType("Linux");
            vr.setSd(sd);
            return vr;
        }
        catch (ConnClientException | InterruptedException e) {
            LOGGER.error("[Connector] Exception waiting for VM Creation");
            throw new ConnException(e);
        }
    }

    @Override
    public void destroy(Object id) {
        String jobId = (String)id;
        LOGGER.debug("[Connector] Destroying node for job " + jobId);
        try {
            String resourceName = this.vmidToHostName.get(jobId);
            if (resourceName != null && !resourceName.isEmpty()) {
                if (!this.network.isEmpty()) {
                    resourceName = resourceName.substring(0, resourceName.indexOf(this.network));
                }
                LOGGER.debug("[Connector] Deleting node " + resourceName);
                this.client.deleteCompute(resourceName);
            } else {
                LOGGER.debug("[Connector] Node not found cancelling job " + jobId);
            }
            this.vmidToHardwareRequest.remove(jobId);
            this.vmidToSoftwareRequest.remove(jobId);
            this.vmidToHostName.remove(jobId);
        }
        catch (ConnClientException cce) {
            LOGGER.error("[Connector] Exception waiting for Node Destruction", (Throwable)cce);
        }
        LOGGER.debug("[Connector] Node for job " + jobId + " destroyed.");
        --this.currentNodes;
    }

    @Override
    public float getPriceSlot(VirtualResource virtualResource) {
        return virtualResource.getHd().getPricePerUnit();
    }

    @Override
    public void close() {
    }
}

