/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.conn.clients.slurm;

import es.bsc.conn.clients.exceptions.ConnClientException;
import es.bsc.conn.clients.slurm.JobDescription;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SlurmClient {
    private static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Connectors.Conn.Clients.SLURM");
    private static final String EXPECTED_RESULT = "salloc: Pending job allocation ";
    private static final String SLURM_CMD = "[Client] Slurm CMD: ";
    private static final String ERROR_SLURM_CMD = "[Client] Error on Slurm CMD";
    private final String mainJobId;
    private final String masterId;
    private Map<String, String> nodeToJobId = new HashMap<String, String>();
    private Map<String, List<String>> jobIdToNodes = new HashMap<String, List<String>>();
    private final int initialNodes;
    private final boolean ssh;
    private final boolean expand;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SlurmClient(String masterId, boolean ssh, boolean expand) {
        this.masterId = masterId;
        this.ssh = ssh;
        this.expand = expand;
        LOGGER.info("[Client] Initializing SLURM Client (" + this.masterId + " " + this.ssh + " " + this.expand + ")");
        List<String> nodeIds = this.parseNodes();
        this.initialNodes = nodeIds.size();
        this.mainJobId = System.getenv("SLURM_JOB_ID");
        if (this.mainJobId != null && nodeIds != null && !nodeIds.isEmpty()) {
            this.jobIdToNodes.put(this.mainJobId, nodeIds);
            Map<String, String> map = this.nodeToJobId;
            synchronized (map) {
                for (String nodeId : nodeIds) {
                    this.nodeToJobId.put(nodeId, this.mainJobId);
                }
            }
        } else {
            LOGGER.error("[Client] ERROR no SLURM_JOB_ID defined SLURM client will not work");
        }
    }

    public int getInitialNodes() {
        return this.initialNodes;
    }

    private List<String> parseNodes() {
        String slurmNL = System.getenv("SLURM_JOB_NODELIST");
        LinkedList<String> list = new LinkedList<String>();
        if (slurmNL != null) {
            JobDescription.parseNodelist(slurmNL, list);
        }
        return list;
    }

    public JobDescription getJobDescription(String jobId) throws ConnClientException {
        String cmd = "scontrol show JobId=" + jobId;
        try {
            LOGGER.debug(SLURM_CMD + cmd);
            return new JobDescription(this.executeCmd(cmd));
        }
        catch (ConnClientException ie) {
            LOGGER.error(ERROR_SLURM_CMD, (Throwable)ie);
            throw new ConnClientException(ie);
        }
    }

    public String getJobStatus(String jobId) throws ConnClientException {
        String cmd = "sacct -j" + jobId + "-n -P -o status ";
        try {
            LOGGER.debug(SLURM_CMD + cmd);
            return this.executeCmd(cmd);
        }
        catch (ConnClientException ie) {
            LOGGER.error(ERROR_SLURM_CMD, (Throwable)ie);
            throw new ConnClientException(ie);
        }
    }

    public void cancelJob(String jobId) throws ConnClientException {
        String cmd = "scancel " + jobId;
        try {
            LOGGER.debug(SLURM_CMD + cmd);
            this.executeCmd(cmd);
        }
        catch (ConnClientException ie) {
            LOGGER.error(ERROR_SLURM_CMD, (Throwable)ie);
            throw new ConnClientException(ie);
        }
    }

    public void updateJob(String jobId, String args) {
        String cmd = "scontrol update JobId=" + jobId + " " + args;
        try {
            LOGGER.debug(SLURM_CMD + cmd);
            this.executeCmd(cmd);
        }
        catch (ConnClientException e) {
            LOGGER.warn(ERROR_SLURM_CMD, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteCompute(String resourceId) throws ConnClientException {
        if (!resourceId.equals(this.masterId)) {
            String args = "NodeList=" + this.masterId;
            int nodes = 1;
            String nodeJobId = null;
            Map<String, String> map = this.nodeToJobId;
            synchronized (map) {
                nodeJobId = this.nodeToJobId.get(resourceId);
                this.nodeToJobId.remove(resourceId);
                for (String node : this.nodeToJobId.keySet()) {
                    if (node.equals(this.masterId)) continue;
                    args = args.concat("," + node);
                    ++nodes;
                }
            }
            args = args.concat(" NumNodes=" + nodes);
            this.updateJob(this.mainJobId, args);
            if (nodeJobId != null) {
                List<String> nodesInJob = this.jobIdToNodes.get(nodeJobId);
                nodesInJob.remove(resourceId);
                if (nodesInJob.isEmpty()) {
                    this.jobIdToNodes.remove(nodeJobId);
                } else {
                    LOGGER.warn("Job " + nodeJobId + " is not empty. Skiping job cancel ");
                }
            } else {
                LOGGER.warn("JobId for resource " + resourceId + " does not exist");
            }
        } else {
            LOGGER.warn("Trying to remove master node. It is not allowed");
        }
    }

    public String createCompute(JobDescription jobDesc, String script) throws ConnClientException {
        String cmd = null;
        cmd = this.expand ? "salloc --dependency=expand:" + this.mainJobId + " " + jobDesc.generateRequest() + " " + script + " " + this.mainJobId + " & sleep 1; disown $!" : "nohup salloc " + jobDesc.generateRequest() + " " + script + " & sleep 1; disown $!";
        LOGGER.debug(SLURM_CMD + cmd);
        return this.parseJobIDFormCreationOutput(this.executeCmd(cmd));
    }

    private String parseJobIDFormCreationOutput(String executeResult) throws ConnClientException {
        String result = executeResult;
        String[] lines = executeResult.split("\n");
        if (lines != null && lines.length > 0) {
            result = lines[0];
        }
        if (result.startsWith(EXPECTED_RESULT)) {
            return result.substring(EXPECTED_RESULT.length());
        }
        throw new ConnClientException("Results is not starting as expected. Current: \"" + result + "\" does not starts with \"" + EXPECTED_RESULT + "\"");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNodesToMain(String jobId, List<String> nodeIds) throws ConnClientException {
        this.jobIdToNodes.put(jobId, nodeIds);
        String args = "NodeList=" + this.masterId;
        int nodes = 1;
        Map<String, String> map = this.nodeToJobId;
        synchronized (map) {
            for (String nodeId : nodeIds) {
                this.nodeToJobId.put(nodeId, jobId);
            }
            for (String node : this.nodeToJobId.keySet()) {
                if (node.equals(this.masterId)) continue;
                args = args.concat("," + node);
                ++nodes;
            }
        }
        args = args.concat(" NumNodes=" + nodes);
        this.updateJob(this.mainJobId, args);
    }

    private String executeCmd(String cmdToRun) throws ConnClientException {
        try {
            String line;
            String cmd = this.ssh ? "ssh " + this.masterId + " " + cmdToRun : cmdToRun;
            LOGGER.info("[Client] Execute CMD (" + this.ssh + "): " + cmd);
            ProcessBuilder pb = new ProcessBuilder(new String[0]);
            pb.command(cmd.split(" "));
            pb.environment().remove("LD_PRELOAD");
            Process p = pb.start();
            BufferedReader stdInput1 = new BufferedReader(new InputStreamReader(p.getInputStream()));
            BufferedReader stdError1 = new BufferedReader(new InputStreamReader(p.getErrorStream()));
            LOGGER.debug("[Client] Execute CMD Output:");
            StringBuilder cmdResult = new StringBuilder();
            while ((line = stdInput1.readLine()) != null) {
                LOGGER.debug(line);
                cmdResult.append(line + "\n");
            }
            LOGGER.error("[Client] Execute CMD Error:");
            while ((line = stdError1.readLine()) != null) {
                LOGGER.error(line);
                cmdResult.append(line + "\n");
            }
            p.waitFor();
            LOGGER.info("[Client] Excute CMD exitValue: " + p.exitValue());
            LOGGER.info("__________________________________________");
            return cmdResult.toString();
        }
        catch (IOException | InterruptedException e) {
            throw new ConnClientException(e);
        }
    }
}

