/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.conn.slurm;

import es.bsc.conn.Connector;
import es.bsc.conn.clients.exceptions.ConnClientException;
import es.bsc.conn.clients.slurm.JobDescription;
import es.bsc.conn.clients.slurm.SlurmClient;
import es.bsc.conn.exceptions.ConnException;
import es.bsc.conn.types.HardwareDescription;
import es.bsc.conn.types.InstallationDescription;
import es.bsc.conn.types.Processor;
import es.bsc.conn.types.SoftwareDescription;
import es.bsc.conn.types.StarterCommand;
import es.bsc.conn.types.VirtualResource;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SlurmConnector
extends Connector {
    private static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Connectors.Conn.SLURM");
    private static final boolean DEBUG = LOGGER.isDebugEnabled();
    private static final String RUNNING = "RUNNING";
    private static final String COMPLETED = "COMPLETED";
    private static final String FAILED = "FAILED";
    private static final long POLLING_INTERVAL = 5L;
    private static final int TIMEOUT = 1800;
    private static final String JOB_STATE = "JobState";
    private static final String JAVA_PROP_DEPLOYMENT_ID = "compss.uuid";
    private static final String NIO_WORKER_STARTER_REL_PATH = File.separator + "Runtime" + File.separator + "scripts" + File.separator + "system" + File.separator + "adaptors" + File.separator + "nio" + File.separator + "persistent_worker_starter.sh";
    private final Map<String, HardwareDescription> vmidToHardwareRequest = new HashMap<String, HardwareDescription>();
    private final Map<String, SoftwareDescription> vmidToSoftwareRequest = new HashMap<String, SoftwareDescription>();
    private final Map<String, String> vmidToHostName = new HashMap<String, String>();
    private final Map<String, String> vmidToExpectedJobOutFile = new HashMap<String, String>();
    private final String logDir;
    private final SlurmClient client;
    private final String network;
    private final boolean memInRequest;
    private int currentNodes;
    private boolean batch;

    public SlurmConnector(Map<String, String> props) throws ConnException {
        super(props);
        String appLogdir = System.getProperty("compss.appLogDir");
        if (appLogdir == null) {
            throw new ConnException("[Connector] Unable to get app log dir");
        }
        File f = new File(appLogdir + File.separator + "slurm-conn-log");
        if (f.mkdirs()) {
            this.logDir = f.getAbsolutePath();
        } else if (f.exists()) {
            this.logDir = f.getAbsolutePath();
        } else {
            throw new ConnException("[Connector] Unable to create SLURM connector log dir " + f.getAbsolutePath());
        }
        String masterName = props.get("master_name");
        if (masterName == null || masterName.isEmpty()) {
            throw new ConnException("[Connector] Unable to get master_name. Property is empty");
        }
        boolean ssh = false;
        String sshStr = props.get("slurm_over_ssh");
        if (sshStr != null && !sshStr.isEmpty()) {
            ssh = Boolean.parseBoolean(sshStr);
        }
        boolean expand = true;
        String expandStr = props.get("expand_job");
        if (expandStr != null && !expandStr.isEmpty()) {
            expand = Boolean.parseBoolean(expandStr);
        }
        this.batch = false;
        String batchStr = props.get("batch_job");
        if (batchStr != null && !batchStr.isEmpty()) {
            this.batch = Boolean.parseBoolean(batchStr);
        }
        LOGGER.debug("[Connector] Starting Slurm client (jobName) for master in " + masterName + ", ssh " + ssh + " and expand " + expand);
        this.client = new SlurmClient(masterName, ssh, expand, this.batch);
        String networkProp = props.get("network");
        this.network = networkProp == null ? "" : networkProp;
        String memInReqStr = props.get("mem_in_req");
        this.memInRequest = memInReqStr != null && !memInReqStr.isEmpty() ? Boolean.parseBoolean(memInReqStr) : false;
        this.currentNodes = 0;
    }

    @Override
    public Object create(String requestName, HardwareDescription hd, SoftwareDescription sd, Map<String, String> prop, StarterCommand starterCMD) throws ConnException {
        try {
            String jobName = requestName;
            ++this.currentNodes;
            JobDescription jobDesc = this.generateJobDescription(hd, sd);
            String execScript = this.generateExecScript(jobName, hd, sd, prop, starterCMD);
            String jobId = this.client.createCompute(jobDesc, execScript);
            this.vmidToHardwareRequest.put(jobId, hd);
            this.vmidToSoftwareRequest.put(jobId, sd);
            this.vmidToExpectedJobOutFile.put(jobId, this.logDir + File.separator + jobName + ".out");
            VirtualResource vr = new VirtualResource(jobId, hd, sd, prop);
            return vr.getId();
        }
        catch (ConnClientException ce) {
            LOGGER.error("[Connector] Exception submitting job for creation", (Throwable)ce);
            --this.currentNodes;
            throw new ConnException(ce);
        }
        catch (Exception e) {
            LOGGER.error("[Connector] Exception submitting job for node creation", (Throwable)e);
            throw new ConnException(e);
        }
    }

    @Override
    public Object[] createMultiple(int replicas, String requestName, HardwareDescription hd, SoftwareDescription sd, Map<String, String> prop, StarterCommand starterCMD) throws ConnException {
        Object[] envIds = new Object[replicas];
        for (int i = 0; i < replicas; ++i) {
            envIds[i] = this.create(requestName, hd, sd, prop, starterCMD);
        }
        return envIds;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String generateExecScript(String jobName, HardwareDescription hd, SoftwareDescription sd, Map<String, String> prop, StarterCommand starterCMD) throws ConnException {
        InstallationDescription instDesc;
        String installDir;
        String stdFlags = this.generateFlags(jobName, prop);
        String launchCommand = prop.get("launch_command");
        if (launchCommand == null || launchCommand.isEmpty()) {
            LOGGER.debug("[Connector] launch command not found adding srun");
            launchCommand = "srun -N1 -n1 --nodelist=";
        }
        StringBuilder completeCommand = new StringBuilder("#!/bin/sh\n");
        if (!this.batch) {
            completeCommand.append("echo \"NodeList=$SLURM_JOB_NODELIST\" > " + this.logDir + File.separator + jobName + ".out\n");
            completeCommand.append("node=$SLURM_JOB_NODELIST\n");
            completeCommand.append("scontrol update jobId=$SLURM_JOBID NumNodes=0 1>> " + this.logDir + File.separator + jobName + ".out" + " 2> " + this.logDir + File.separator + jobName + ".err\n");
            completeCommand.append("scontrol update jobId=$1 NumNodes=ALL 1>> " + this.logDir + File.separator + jobName + ".out" + " 2>> " + this.logDir + File.separator + jobName + ".err\n");
            completeCommand.append(". ./slurm_job_${1}_resize.sh 1>> " + this.logDir + File.separator + jobName + ".out" + " 2>> " + this.logDir + File.separator + jobName + ".err\n");
            completeCommand.append(" nohup " + launchCommand + "${node} --jobid=$1 ");
        } else {
            completeCommand.append("node=$SLURM_JOB_NODELIST\n");
            completeCommand.append(launchCommand + "${SLURM_JOB_NODELIST} ");
        }
        if (hd.getImageName() != null && !hd.getImageName().isEmpty() && !"None".equals(hd.getImageName())) {
            completeCommand.append("singularity exec ");
            String containerOpts = prop.get("container_opts");
            if (containerOpts != null && !containerOpts.isEmpty()) {
                completeCommand.append(containerOpts + " ");
            }
            completeCommand.append(hd.getImageName());
        }
        if ((installDir = (instDesc = sd.getInstallation()).getInstallDir()) == null || installDir.isEmpty()) {
            installDir = System.getenv("COMPSS_HOME");
            if (installDir == null) throw new ConnException("[Connector] Unable to get COMPSs installation directory");
            if (installDir.isEmpty()) {
                throw new ConnException("[Connector] Unable to get COMPSs installation directory");
            }
        }
        String workingDir = starterCMD.getBaseWorkingDir();
        String deploymentId = System.getProperty(JAVA_PROP_DEPLOYMENT_ID);
        String nodeName = "${node}" + this.network;
        starterCMD.setScriptName(installDir + NIO_WORKER_STARTER_REL_PATH);
        starterCMD.setWorkerName(nodeName);
        starterCMD.setSandboxedWorkingDir(workingDir + File.separator + deploymentId + File.separator + nodeName + File.separator);
        starterCMD.setNodeId(String.valueOf(this.client.getInitialNodes() + this.currentNodes));
        try {
            String[] cmd;
            for (String s : cmd = starterCMD.getStartCommand()) {
                completeCommand.append(" " + s);
            }
            if (!this.batch) {
                completeCommand.append(" 1>> " + this.logDir + File.separator + jobName + ".out" + " 2>> " + this.logDir + File.separator + jobName + ".err &");
            }
        }
        catch (Exception e) {
            throw new ConnException(e);
        }
        File runScript = new File(this.logDir + File.separator + "run_" + jobName);
        try {
            if (!runScript.createNewFile()) {
                throw new IOException("[Connector] ERROR: File " + runScript + " already exists");
            }
            if (!runScript.setExecutable(true)) {
                throw new IOException("[Connector] ERROR: Cannot make the file executable");
            }
        }
        catch (IOException ioe) {
            throw new ConnException("[Connector] Exception creating script", ioe);
        }
        try (FileOutputStream fos = new FileOutputStream(runScript);){
            fos.write(completeCommand.toString().getBytes());
            String string = stdFlags + " " + runScript.getAbsolutePath();
            return string;
        }
        catch (IOException e) {
            throw new ConnException("[Connector] Exception writting script", e);
        }
    }

    private String generateFlags(String jobName, Map<String, String> prop) {
        String constraint;
        String qos;
        String reservation;
        String queue;
        StringBuilder flags = new StringBuilder("--job-name=" + jobName);
        if (this.batch) {
            flags.append(" -e " + this.logDir + File.separator + jobName + ".err" + " -o " + this.logDir + File.separator + jobName + ".out");
        }
        if ((queue = prop.get("queue")) != null && !queue.isEmpty()) {
            flags.append(" -p " + queue);
        }
        if ((reservation = prop.get("reservation")) != null && !reservation.isEmpty()) {
            flags.append(" --reservation=" + reservation);
        }
        if ((qos = prop.get("qos")) != null && !qos.isEmpty()) {
            flags.append(" --qos=" + qos);
        }
        if ((constraint = prop.get("constraint")) != null && !constraint.isEmpty()) {
            flags.append(" --constraint=" + constraint);
        }
        return flags.toString();
    }

    private JobDescription generateJobDescription(HardwareDescription hd, SoftwareDescription sd) {
        if (DEBUG) {
            LOGGER.debug("Generating Job description from:");
            LOGGER.debug(" - HD: " + hd);
            LOGGER.debug(" - SD: " + sd);
        }
        HashMap<String, String> req = new HashMap<String, String>();
        req.put("NumNodes", "1");
        req.put("NumCPUs", Integer.toString(hd.getTotalCPUComputingUnits()));
        if (this.memInRequest && hd.getMemorySize() > 0.0f) {
            req.put("mem", Integer.toString((int)hd.getMemorySize() * 1024));
        }
        int gpuUnits = 0;
        for (Processor p : hd.getProcessors()) {
            if (!"GPU".equals(p.getArchitecture())) continue;
            gpuUnits += p.getComputingUnits();
        }
        if (gpuUnits > 0) {
            req.put("Gres", Integer.toString(gpuUnits));
        } else if (hd.getTotalGPUComputingUnits() > 0) {
            req.put("Gres", "gpu:" + Integer.toString(hd.getTotalGPUComputingUnits()));
        }
        return new JobDescription(req);
    }

    @Override
    public VirtualResource waitUntilCreation(Object id) throws ConnException {
        LOGGER.debug("[Connector] Waiting for resource creation " + id);
        String jobId = (String)id;
        LOGGER.debug("[Connector] Waiting until node of job " + jobId + " is created");
        try {
            JobDescription jd = this.client.getJobDescription(jobId);
            LOGGER.debug("[Connector] Job State is " + jd.getProperty(JOB_STATE));
            int tries = 0;
            while (jd.getProperty(JOB_STATE) == null || !jd.getProperty(JOB_STATE).equals(RUNNING) && !jd.getProperty(JOB_STATE).equals(COMPLETED)) {
                if (jd.getProperty(JOB_STATE).equals(FAILED)) {
                    LOGGER.error("[Connector] Error waiting for VM Creation. Middleware has return an error state");
                    throw new ConnException("[Connector] Error waiting for VM Creation. Middleware has return an error state");
                }
                if ((long)tries * 5L > 1800L) {
                    this.client.cancelJob(jobId);
                    this.vmidToHardwareRequest.remove(jobId);
                    this.vmidToSoftwareRequest.remove(jobId);
                    this.vmidToExpectedJobOutFile.remove(jobId);
                    throw new ConnException("[Connector] Maximum Job creation time reached.");
                }
                ++tries;
                Thread.sleep(5000L);
                jd = this.client.getJobDescription(jobId);
                LOGGER.debug("[Connector] Job State is " + jd.getProperty(JOB_STATE));
            }
            List<String> nodeList = jd.getNodeList();
            if (nodeList == null || nodeList.isEmpty()) {
                nodeList = this.readNodeList(jobId);
            }
            if (!this.batch) {
                this.client.addNodesToMain(jobId, nodeList);
            }
            VirtualResource vr = new VirtualResource();
            vr.setId(jobId);
            String resourceName = nodeList.get(0) + this.network;
            LOGGER.debug("[Connector] Setting resource ip: " + resourceName);
            this.vmidToHostName.put(jobId, resourceName);
            this.vmidToExpectedJobOutFile.remove(jobId);
            vr.setIp(resourceName);
            vr.setProperties(null);
            HardwareDescription hd = this.vmidToHardwareRequest.get(jobId);
            if (hd == null) {
                throw new ConnException("[Connector] Unregistered hardware description for job " + jobId);
            }
            vr.setHd(hd);
            SoftwareDescription sd = this.vmidToSoftwareRequest.get(jobId);
            if (sd == null) {
                throw new ConnException("[Connector] Unregistered software description for job " + jobId);
            }
            sd.setOperatingSystemType("Linux");
            vr.setSd(sd);
            return vr;
        }
        catch (ConnClientException | InterruptedException e) {
            LOGGER.error("[Connector] Exception waiting for VM Creation");
            throw new ConnException(e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private List<String> readNodeList(String jobId) throws ConnException {
        block33: {
            String fileName = this.vmidToExpectedJobOutFile.get(jobId);
            if (fileName == null) break block33;
            try {
                Throwable throwable = null;
                try (FileReader fr = new FileReader(fileName);){
                    String line;
                    Throwable throwable2;
                    BufferedReader br;
                    block30: {
                        ArrayList<String> arrayList;
                        block31: {
                            block32: {
                                br = new BufferedReader(fr);
                                throwable2 = null;
                                line = br.readLine();
                                if (line == null) {
                                    throw new ConnException("[Connector] No line to read in expected job " + jobId + " out file.");
                                }
                                String separator = "NodeList=";
                                if (!line.startsWith(separator)) break block30;
                                line = line.substring(separator.length());
                                ArrayList<String> nodeList = new ArrayList<String>();
                                JobDescription.parseNodelist(line, nodeList);
                                arrayList = nodeList;
                                if (br == null) break block31;
                                if (throwable2 == null) break block32;
                                try {
                                    br.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable2.addSuppressed(throwable3);
                                }
                                break block31;
                            }
                            br.close();
                        }
                        return arrayList;
                    }
                    try {
                        try {
                            try {
                                try {
                                    throw new ConnException("[Connector] Incorrect line format in expected job " + jobId + " out file. (" + line + ")");
                                }
                                catch (Throwable throwable4) {
                                    throwable2 = throwable4;
                                    throw throwable4;
                                }
                            }
                            catch (Throwable throwable5) {
                                if (br != null) {
                                    if (throwable2 != null) {
                                        try {
                                            br.close();
                                        }
                                        catch (Throwable throwable6) {
                                            throwable2.addSuppressed(throwable6);
                                        }
                                    } else {
                                        br.close();
                                    }
                                }
                                throw throwable5;
                            }
                        }
                        catch (Exception e) {
                            LOGGER.error("[Connector] Exception reading expected job " + jobId + " out file " + fileName);
                            throw new ConnException(e);
                        }
                    }
                    catch (Throwable throwable7) {
                        throwable = throwable7;
                        throw throwable7;
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("[Connector] Exception reading expected job " + jobId + " out file " + fileName);
                throw new ConnException(e);
            }
        }
        throw new ConnException("[Connector] Expected job " + jobId + " out file is null. ");
    }

    @Override
    public void destroy(Object id) {
        String jobId = (String)id;
        LOGGER.debug("[Connector] Destroying node for job " + jobId);
        try {
            String resourceName = this.vmidToHostName.get(jobId);
            if (resourceName != null && !resourceName.isEmpty()) {
                if (!this.network.isEmpty()) {
                    resourceName = resourceName.substring(0, resourceName.indexOf(this.network));
                }
                LOGGER.debug("[Connector] Deleting node " + resourceName);
                this.client.deleteCompute(resourceName);
            } else {
                LOGGER.debug("[Connector] Node not found cancelling job " + jobId);
            }
            this.vmidToHardwareRequest.remove(jobId);
            this.vmidToSoftwareRequest.remove(jobId);
            this.vmidToHostName.remove(jobId);
        }
        catch (ConnClientException cce) {
            LOGGER.error("[Connector] Exception waiting for Node Destruction", (Throwable)cce);
        }
        LOGGER.debug("[Connector] Node for job " + jobId + " destroyed.");
        --this.currentNodes;
    }

    @Override
    public float getPriceSlot(VirtualResource virtualResource) {
        return virtualResource.getHd().getPricePerUnit();
    }

    @Override
    public void close() {
    }
}

