/*
 * Decompiled with CFR 0.152.
 */
package taskflows;

import java.util.LinkedList;
import mains.MyElement;
import taskflows.SyntheticTaskFlowTasks;
import taskflows.TaskFlowArguments;

public class SyntheticTaskFlow {
    private static MyElement taskFlowComputation(TaskFlowArguments tfargs) {
        int numElements = tfargs.getNumElements();
        MyElement[] outputs = new MyElement[numElements];
        for (int i = 0; i < numElements; ++i) {
            MyElement input = tfargs.getElement(i);
            for (int j = 0; j < tfargs.getDepth(); ++j) {
                outputs[i] = SyntheticTaskFlowTasks.mapTask(input, tfargs.getSleepBaseTime(), tfargs.getSleepRandomRange());
            }
        }
        LinkedList<Integer> pendingIndexes = new LinkedList<Integer>();
        for (int i = 0; i < numElements; ++i) {
            pendingIndexes.add(i);
        }
        while (pendingIndexes.size() >= 2) {
            int firstIndex = (Integer)pendingIndexes.poll();
            int secondIndex = (Integer)pendingIndexes.poll();
            SyntheticTaskFlowTasks.mergeTask(outputs[firstIndex], outputs[secondIndex], tfargs.getSleepBaseTime(), tfargs.getSleepRandomRange());
            pendingIndexes.add(firstIndex);
        }
        return outputs[(Integer)pendingIndexes.poll()];
    }

    public static void main(String[] args) {
        System.out.println("[INFO] Starting application");
        long start = System.currentTimeMillis();
        System.out.println("[INFO] Parsing application arguments");
        TaskFlowArguments tfargs = new TaskFlowArguments(args);
        System.out.println("[INFO] Launching task flow computation");
        MyElement res = SyntheticTaskFlow.taskFlowComputation(tfargs);
        System.out.println("[INFO] Syncrhonizing final output");
        System.out.println("Computation result is: " + res);
        System.out.println("DONE");
        long end = System.currentTimeMillis();
        long elapsedTime = end - start;
        System.out.println("[TIME] TOTAL ELAPSED: " + elapsedTime);
    }
}

