/*
 * Decompiled with CFR 0.152.
 */
package mains;

import compss.NESTED;
import es.bsc.compss.api.COMPSs;
import es.bsc.distrostreamlib.api.objects.ObjectDistroStream;
import es.bsc.distrostreamlib.types.ConsumerMode;
import java.util.LinkedList;
import mains.MyElement;
import mains.NestedHybridArguments;
import mains.NestedHybridTasks;

public class NestedHybrid {
    public static void main(String[] args) throws Exception {
        System.out.println("[INFO] Starting application");
        long start = System.currentTimeMillis();
        System.out.println("[INFO] Parsing application arguments");
        NestedHybridArguments nhargs = new NestedHybridArguments(args);
        System.out.println("[INFO] Creating streams");
        ObjectDistroStream odsSensor = new ObjectDistroStream("sensor", ConsumerMode.AT_MOST_ONCE);
        ObjectDistroStream odsFiltered = new ObjectDistroStream("filtered", ConsumerMode.AT_MOST_ONCE);
        System.out.println("[INFO] Launching sensor");
        NestedHybridTasks.sensor((ObjectDistroStream<MyElement>)odsSensor, nhargs.getSensorNumFiles(), nhargs.getSensorSleepBaseTime(), nhargs.getSensorSleepRandomRange());
        System.out.println("[INFO] Launching filter nested");
        NESTED.nestedBigFilter((ObjectDistroStream<MyElement>)odsSensor, (ObjectDistroStream<MyElement>)odsFiltered, nhargs.getBatchSize(), nhargs.getFilterSleepBaseTime(), nhargs.getFilterSleepRandomRange());
        System.out.println("[INFO] Launching extract");
        LinkedList<MyElement> elems = NestedHybridTasks.extractInfo((ObjectDistroStream<MyElement>)odsFiltered, nhargs.getExtractSleepBaseTime(), nhargs.getExtractSleepRandomRange());
        System.out.println("[INFO] Launching task flow computation");
        Integer res = NESTED.nestedTaskFlow(elems, nhargs.getTaskFlowDepth(), nhargs.getTaskFlowSleepBaseTime(), nhargs.getTaskFlowSleepRandomRange());
        System.out.println("[INFO] Synchronizing final output");
        System.out.println("[INFO] TF ended with status: " + res);
        COMPSs.barrier();
        System.out.println("DONE");
        long end = System.currentTimeMillis();
        long elapsedTime = end - start;
        System.out.println("[TIME] TOTAL ELAPSED: " + elapsedTime);
    }
}

