/*
 * Decompiled with CFR 0.152.
 */
package mains;

import es.bsc.distrostreamlib.api.objects.ObjectDistroStream;
import es.bsc.distrostreamlib.exceptions.BackendException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import mains.MyElement;

public class NestedHybridTasks {
    private static final int SENSOR_INITIAL_DELAY = 10000;
    private static final int TIME_BETWEEN_POLLS = 5000;
    private static final int EXTRACT_ACCEPT_RATE = 5;

    public static void sensor(ObjectDistroStream<MyElement> odsSensor, int numFiles, int sleepBaseTime, int sleepRandomRange) throws BackendException, InterruptedException {
        System.out.println("[DEBUG] Starting sensor");
        Thread.sleep(10000L);
        for (int i = 0; i < numFiles; ++i) {
            List<String> inputFiles = Arrays.asList("object" + i);
            MyElement e = new MyElement(inputFiles);
            System.out.println("[DEBUG] Publishing object " + e);
            odsSensor.publish((Object)e);
            Random randomGenerator = new Random();
            int randomInt = randomGenerator.nextInt(sleepRandomRange);
            int sleepTime = sleepBaseTime + randomInt;
            Thread.sleep(sleepTime);
        }
        System.out.println("[DEBUG] Notifying stream closure");
        odsSensor.close();
        System.out.println("[DEBUG] Stopping sensor");
    }

    public static LinkedList<MyElement> extractInfo(ObjectDistroStream<MyElement> odsFiltered, int sleepBaseTime, int sleepRandomRange) throws BackendException, InterruptedException {
        List<MyElement> newElements;
        System.out.println("[DEBUG] Starting extractInfo");
        LinkedList<MyElement> elements = new LinkedList<MyElement>();
        while (!odsFiltered.isClosed()) {
            Thread.sleep(5000L);
            newElements = NestedHybridTasks.getAndExtract(odsFiltered, sleepBaseTime, sleepRandomRange);
            elements.addAll(newElements);
        }
        newElements = NestedHybridTasks.getAndExtract(odsFiltered, sleepBaseTime, sleepRandomRange);
        elements.addAll(newElements);
        System.out.println("[DEBUG] Detected valid elements: " + elements);
        return elements;
    }

    private static List<MyElement> getAndExtract(ObjectDistroStream<MyElement> odsFiltered, int sleepBaseTime, int sleepRandomRange) throws InterruptedException, BackendException {
        System.out.println("[DEBUG] Polling new files");
        List newElements = odsFiltered.poll();
        LinkedList<MyElement> validElements = new LinkedList<MyElement>();
        for (MyElement elem : newElements) {
            System.out.println("[DEBUG] Processing object " + elem);
            Random randomGenerator = new Random();
            int randomFilterExtract = randomGenerator.nextInt(10);
            if (randomFilterExtract < 5) continue;
            int randomInt = randomGenerator.nextInt(sleepRandomRange);
            int sleepTime = sleepBaseTime + randomInt;
            Thread.sleep(sleepTime);
            validElements.add(elem);
        }
        return validElements;
    }
}

