/*
 * Decompiled with CFR 0.152.
 */
package simulations;

import es.bsc.compss.api.COMPSs;
import es.bsc.distrostreamlib.api.objects.ObjectDistroStream;
import es.bsc.distrostreamlib.exceptions.BackendException;
import es.bsc.distrostreamlib.exceptions.RegistrationException;
import es.bsc.distrostreamlib.types.ConsumerMode;
import java.util.ArrayList;
import java.util.List;
import mains.State;
import simulations.SimulationArguments;

public class Simulation {
    private static State simulate(SimulationArguments sArgs) throws RegistrationException, BackendException {
        System.out.println("[INFO] Creating read stream");
        String readStreamAlias = sArgs.getReadStreamAlias();
        ObjectDistroStream readStream = new ObjectDistroStream(readStreamAlias, ConsumerMode.AT_MOST_ONCE);
        System.out.println("[INFO] Creating write streams");
        ArrayList<ObjectDistroStream> writeStreams = new ArrayList<ObjectDistroStream>();
        for (String streamAlias : sArgs.getWriteStreamAliases()) {
            ObjectDistroStream stream = new ObjectDistroStream(streamAlias, ConsumerMode.AT_MOST_ONCE);
            writeStreams.add(stream);
        }
        System.out.println("[INFO] Performing simulation iterations");
        State currentState = new State();
        for (int i = 0; i < sArgs.getNumIterations(); ++i) {
            System.out.println("[DEBUG] Begin iteration " + i);
            System.out.println("[DEBUG] Performing local simulation");
            currentState.accumulateLocal(sArgs.getSleepBaseTime(), sArgs.getSleepRandomRange());
            COMPSs.barrier();
            System.out.println("[DEBUG] Communicating TO other simulations");
            for (ObjectDistroStream wStream : writeStreams) {
                if (wStream.isClosed()) continue;
                wStream.publish((Object)currentState);
            }
            System.out.println("[DEBUG] Communicating FROM other simulations");
            List incommingElements = readStream.poll();
            if (incommingElements == null) continue;
            for (State elem : incommingElements) {
                System.out.println("[DEBUG] Received element: " + elem);
                currentState.accumulateForeign(sArgs.getSleepBaseTime(), sArgs.getSleepRandomRange());
            }
        }
        System.out.println("[INFO] Simulation finished");
        return currentState;
    }

    public static void main(String[] args) throws Exception {
        System.out.println("[INFO] Starting application");
        long start = System.currentTimeMillis();
        System.out.println("[INFO] Parsing application arguments");
        SimulationArguments sArgs = new SimulationArguments(args);
        System.out.println("[INFO] Launching simulation");
        State res = Simulation.simulate(sArgs);
        System.out.println("[INFO] Waiting for simulation to end");
        System.out.println("Computation result is: " + res);
        System.out.println("DONE");
        long end = System.currentTimeMillis();
        long elapsedTime = end - start;
        System.out.println("[TIME] TOTAL ELAPSED: " + elapsedTime);
    }
}

