/*
 * Decompiled with CFR 0.152.
 */
package main;

import es.bsc.compss.api.COMPSs;
import es.bsc.distrostreamlib.api.objects.ObjectDistroStream;
import es.bsc.distrostreamlib.types.ConsumerMode;
import main.ReadWriteImpl;
import simsync.types.Element;

public class ReadWrite {
    private static final int NUM_TOTAL_ELEMENTS = 100;

    public static void main(String[] args) throws Exception {
        System.out.println("[INFO] Starting application");
        long start = System.currentTimeMillis();
        int numWriters = Integer.parseInt(args[0]);
        int numReaders = Integer.parseInt(args[1]);
        System.out.println("[INFO] WRITERS: " + numWriters);
        System.out.println("[INFO] READERS: " + numReaders);
        ObjectDistroStream ods = new ObjectDistroStream(ConsumerMode.AT_MOST_ONCE);
        int elemsPerWriter = 100 / numWriters;
        for (int i = 0; i < numWriters; ++i) {
            ReadWriteImpl.write((ObjectDistroStream<Element>)ods, elemsPerWriter);
        }
        Integer[] processedElemsPerReader = new Integer[numReaders];
        for (int i = 0; i < numReaders; ++i) {
            processedElemsPerReader[i] = ReadWriteImpl.read((ObjectDistroStream<Element>)ods);
        }
        int total = 0;
        for (int i = 0; i < numReaders; ++i) {
            System.out.println("Reader " + i + " processed " + processedElemsPerReader[i] + " elements");
            total += processedElemsPerReader[i].intValue();
        }
        System.out.println("[INFO] TOTAL ELEMENTS: " + total);
        COMPSs.barrier();
        System.out.println("[INFO] DONE");
        long end = System.currentTimeMillis();
        long elapsedTime = end - start;
        System.out.println("[TIME] TOTAL ELAPSED: " + elapsedTime + " ms");
    }
}

