/*
 * Decompiled with CFR 0.152.
 */
package simsync;

import es.bsc.distrostreamlib.api.objects.ObjectDistroStream;
import es.bsc.distrostreamlib.exceptions.BackendException;
import java.util.List;
import simsync.types.State;

public class SimSyncImpl {
    private static final boolean DEBUG = false;

    public static final State initializeState() {
        State currentState = new State();
        return currentState;
    }

    public static final void simulationIter(State myState, int processTime) {
        myState.accumulateLocal(processTime, 1);
    }

    public static final void exchangeInfo(State myState, State otherState, int processTime) {
        myState.accumulateForeign(processTime, 1);
        otherState.accumulateForeign(processTime, 1);
    }

    public static final State fullSimulation(ObjectDistroStream<State> myStates, ObjectDistroStream<State> theirStates, int numIterations, int processTime) throws BackendException {
        State currentState = new State();
        for (int i = 0; i < numIterations; ++i) {
            currentState.accumulateLocal(processTime, 1);
            theirStates.publish((Object)currentState);
            List incommingElements = null;
            while (incommingElements == null || incommingElements.isEmpty()) {
                incommingElements = myStates.poll();
            }
            for (State elem : incommingElements) {
                currentState.accumulateForeign(processTime, 1);
            }
        }
        myStates.close();
        return currentState;
    }
}

