/*
 * Decompiled with CFR 0.152.
 */
package simsync;

import es.bsc.compss.api.COMPSs;
import es.bsc.distrostreamlib.api.objects.ObjectDistroStream;
import es.bsc.distrostreamlib.exceptions.BackendException;
import es.bsc.distrostreamlib.exceptions.RegistrationException;
import es.bsc.distrostreamlib.types.ConsumerMode;
import java.util.ArrayList;
import simsync.SimSyncImpl;
import simsync.types.State;

public class SimSync {
    private static final int NUM_SIMULATIONS = 2;

    public static void main(String[] args) throws Exception {
        System.out.println("[INFO] Starting application");
        long start = System.currentTimeMillis();
        int numIterations = Integer.parseInt(args[0]);
        int processTime = Integer.parseInt(args[1]);
        long timeNormalStart = System.currentTimeMillis();
        SimSync.normalSims(numIterations, processTime);
        COMPSs.barrier();
        long timeNormalEnd = System.currentTimeMillis();
        long timeNormalElapsed = timeNormalEnd - timeNormalStart;
        System.out.println("[TIME] NORMAL ELAPSED: " + timeNormalElapsed + " ms");
        long timeStreamStart = System.currentTimeMillis();
        SimSync.streamSims(numIterations, processTime);
        COMPSs.barrier();
        long timeStreamEnd = System.currentTimeMillis();
        long timeStreamElapsed = timeStreamEnd - timeStreamStart;
        System.out.println("[TIME] STREAMS ELAPSED: " + timeStreamElapsed + " ms");
        System.out.println("DONE");
        long end = System.currentTimeMillis();
        long elapsedTime = end - start;
        System.out.println("[TIME] TOTAL ELAPSED: " + elapsedTime + " ms");
    }

    private static void normalSims(int numIterations, int processTime) {
        int i;
        State[] states = new State[2];
        for (i = 0; i < 2; ++i) {
            states[i] = SimSyncImpl.initializeState();
        }
        for (i = 0; i < numIterations; ++i) {
            for (int j = 0; j < 2; ++j) {
                SimSyncImpl.simulationIter(states[j], processTime);
            }
            SimSyncImpl.exchangeInfo(states[0], states[1], processTime);
        }
        System.out.println("END. Printing final states");
        for (i = 0; i < 2; ++i) {
            System.out.println("State " + i + ": " + states[i]);
        }
    }

    private static void streamSims(int numIterations, int processTime) throws RegistrationException, BackendException {
        System.out.println("[INFO] Creating streams");
        ArrayList<ObjectDistroStream> streams = new ArrayList<ObjectDistroStream>();
        for (int i = 0; i < 2; ++i) {
            String streamAlias = "Simulation" + i;
            ObjectDistroStream ods = new ObjectDistroStream(streamAlias, ConsumerMode.AT_MOST_ONCE);
            streams.add(ods);
        }
        System.out.println("[INFO] Launching simulations");
        State[] finalStates = new State[]{SimSyncImpl.fullSimulation((ObjectDistroStream<State>)((ObjectDistroStream)streams.get(0)), (ObjectDistroStream<State>)((ObjectDistroStream)streams.get(1)), numIterations, processTime), SimSyncImpl.fullSimulation((ObjectDistroStream<State>)((ObjectDistroStream)streams.get(1)), (ObjectDistroStream<State>)((ObjectDistroStream)streams.get(0)), numIterations, processTime)};
        System.out.println("[INFO] Waiting for simulations to finish");
        for (int i = 0; i < 2; ++i) {
            System.out.println("State " + i + ": " + finalStates[i]);
        }
    }
}

