/*
 * Decompiled with CFR 0.152.
 */
package timers;

import es.bsc.compss.api.COMPSs;
import es.bsc.distrostreamlib.api.objects.ObjectDistroStream;
import es.bsc.distrostreamlib.types.ConsumerMode;
import java.util.LinkedList;
import timers.RuntimeTimersImpl;
import timers.types.MyObject;

public class RuntimeTimers {
    private static final int NUM_TASKS = 101;

    public static void main(String[] args) throws Exception {
        int i;
        int i2;
        System.out.println("[INFO] Starting application");
        long start = System.currentTimeMillis();
        int numObjects = Integer.valueOf(args[0]);
        int objectSize = Integer.valueOf(args[1]);
        System.out.println("[INFO] NUM OBJECTS: " + numObjects);
        System.out.println("[INFO] OBJECTS SIZE: " + numObjects);
        LinkedList<MyObject[]> objects = new LinkedList<MyObject[]>();
        for (i2 = 0; i2 < 101; ++i2) {
            MyObject[] taskObjects = new MyObject[numObjects];
            for (int j = 0; j < numObjects; ++j) {
                taskObjects[j] = new MyObject(objectSize);
            }
            objects.add(taskObjects);
        }
        Thread.sleep(5000L);
        for (i2 = 0; i2 < 101; ++i2) {
            RuntimeTimersImpl.normalTask((MyObject[])objects.get(i2));
            COMPSs.barrier();
        }
        long endNormal = System.currentTimeMillis();
        LinkedList<ObjectDistroStream> streams = new LinkedList<ObjectDistroStream>();
        for (i = 0; i < 101; ++i) {
            ObjectDistroStream ods = new ObjectDistroStream(ConsumerMode.AT_MOST_ONCE);
            streams.add(ods);
            for (int j = 0; j < numObjects; ++j) {
                ods.publish((Object)((MyObject[])objects.get(i))[j]);
            }
            ods.close();
        }
        Thread.sleep(5000L);
        for (i = 0; i < 101; ++i) {
            RuntimeTimersImpl.streamTask((ObjectDistroStream<MyObject>)((ObjectDistroStream)streams.get(i)));
            COMPSs.barrier();
        }
        long end = System.currentTimeMillis();
        System.out.println("DONE");
        long elapsedNormal = endNormal - start;
        long elapsedStreams = end - endNormal;
        long elapsedTotal = end - start;
        System.out.println("[TIME] NORMAL ELAPSED: " + elapsedNormal + " ms");
        System.out.println("[TIME] STREAMS ELAPSED: " + elapsedStreams + " ms");
        System.out.println("[TIME] TOTAL ELAPSED: " + elapsedTotal + " ms");
    }
}

