/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.distrostreamlib.server.types;

import es.bsc.distrostreamlib.types.ConsumerMode;
import es.bsc.distrostreamlib.types.StreamType;
import java.util.List;
import java.util.UUID;

public class StreamInfo {
    private final UUID id;
    private final String alias;
    private final StreamType streamType;
    private final ConsumerMode accessMode;
    private final List<String> internalStreamInfo;
    private long pollTimestamp;
    private boolean isClosed;

    public StreamInfo(UUID id, String alias, StreamType streamType, ConsumerMode accessMode, List<String> internalStreamInfo) {
        this.id = id;
        this.alias = alias;
        this.streamType = streamType;
        this.accessMode = accessMode;
        this.internalStreamInfo = internalStreamInfo;
        this.pollTimestamp = -1L;
        this.isClosed = false;
    }

    public UUID getId() {
        return this.id;
    }

    public String getAlias() {
        return this.alias;
    }

    public StreamType getStreamType() {
        return this.streamType;
    }

    public ConsumerMode getAccessMode() {
        return this.accessMode;
    }

    public List<String> getInternalStreamInfo() {
        return this.internalStreamInfo;
    }

    public long getLastPollTimestamp() {
        return this.pollTimestamp;
    }

    public void setPollTimestamp() {
        this.pollTimestamp = System.currentTimeMillis();
    }

    public void setPollTimestamp(long timestamp) {
        this.pollTimestamp = timestamp;
    }

    public boolean isStreamClosed() {
        return this.isClosed;
    }

    public void markAsClosed() {
        this.isClosed = true;
    }
}

