/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.wdc.affinity;

import com.sun.jna.PointerType;
import com.sun.jna.ptr.LongByReference;
import es.bsc.wdc.affinity.CLibrary;
import es.bsc.wdc.affinity.ThreadAffinityException;

public class ThreadAffinity {
    public static void setCurrentThreadAffinity(long mask) throws ThreadAffinityException {
        int cpuMaskSize = 8;
        try {
            int ret = CLibrary.INSTANCE.sched_setaffinity(0, 8, (PointerType)new LongByReference(mask));
            if (ret < 0) {
                throw new ThreadAffinityException("sched_setaffinity( 0, (8) , &(" + mask + ") ) return " + ret);
            }
        }
        catch (Throwable e) {
            throw new ThreadAffinityException("sched_setaffinity( 0, (8) , &(" + mask + ")", e);
        }
    }

    public static void setCurrentThreadAffinity(int[] processors) throws ThreadAffinityException {
        long mask = ThreadAffinity.mask(processors);
        ThreadAffinity.setCurrentThreadAffinity(mask);
    }

    public static long mask(int[] processors) throws ThreadAffinityException {
        if (processors != null && processors.length > 0) {
            long mask = 0L;
            for (int proc : processors) {
                mask += 1L << proc;
            }
            return mask;
        }
        throw new ThreadAffinityException("No processors to set in the affinity mask");
    }

    public static int getCurrentThreadProcessor() throws ThreadAffinityException {
        try {
            return CLibrary.INSTANCE.sched_getcpu();
        }
        catch (Throwable e) {
            throw new ThreadAffinityException(e);
        }
    }
}

