/*
 * Decompiled with CFR 0.152.
 */
package net.revelc.code.formatter;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Objects;
import net.revelc.code.formatter.ConfigurationSource;
import net.revelc.code.formatter.LineEnding;
import org.apache.maven.plugin.logging.Log;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.text.edits.MalformedTreeException;

public abstract class AbstractCacheableFormatter {
    protected Log log;
    protected Charset encoding;

    protected abstract void init(Map<String, String> var1, ConfigurationSource var2);

    protected void initCfg(ConfigurationSource cfg) {
        this.log = cfg.getLog();
        this.encoding = cfg.getEncoding();
    }

    public String formatFile(File file, String originalCode, LineEnding ending) {
        try {
            String formattedCode;
            this.log.debug((CharSequence)("Processing file: " + file + " with line ending: " + (Object)((Object)ending)));
            LineEnding formatterLineEnding = ending;
            if (formatterLineEnding == LineEnding.KEEP) {
                formatterLineEnding = LineEnding.determineLineEnding(originalCode);
                this.log.debug((CharSequence)("Determined line ending: " + (Object)((Object)formatterLineEnding) + " to keep for file: " + file));
            }
            if ((formattedCode = this.doFormat(originalCode, formatterLineEnding)) == null) {
                this.log.debug((CharSequence)"Nothing formatted. Try to fix line endings.");
                formattedCode = AbstractCacheableFormatter.fixLineEnding(originalCode, ending);
            }
            if (formattedCode == null) {
                this.log.debug((CharSequence)"Equal code. Not writing result to file.");
                return originalCode;
            }
            this.log.debug((CharSequence)"Line endings fixed");
            return formattedCode;
        }
        catch (IOException | BadLocationException | MalformedTreeException e) {
            this.log.warn(e);
            return null;
        }
    }

    private static String fixLineEnding(String code, LineEnding ending) {
        if (ending == LineEnding.KEEP) {
            return null;
        }
        LineEnding current = LineEnding.determineLineEnding(code);
        if (current == LineEnding.UNKNOWN) {
            return null;
        }
        if (current == ending) {
            return null;
        }
        if (ending == LineEnding.AUTO && Objects.equals(current.getChars(), ending.getChars())) {
            return null;
        }
        return code.replace(current.getChars(), ending.getChars());
    }

    protected abstract String doFormat(String var1, LineEnding var2) throws IOException, BadLocationException;
}

