/*
 * Decompiled with CFR 0.152.
 */
package net.revelc.code.formatter;

import com.google.common.base.Strings;
import com.google.common.hash.Hashing;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.revelc.code.formatter.ConfigurationSource;
import net.revelc.code.formatter.LineEnding;
import net.revelc.code.formatter.Result;
import net.revelc.code.formatter.css.CssFormatter;
import net.revelc.code.formatter.html.HTMLFormatter;
import net.revelc.code.formatter.java.JavaFormatter;
import net.revelc.code.formatter.javascript.JavascriptFormatter;
import net.revelc.code.formatter.json.JsonFormatter;
import net.revelc.code.formatter.model.ConfigReadException;
import net.revelc.code.formatter.model.ConfigReader;
import net.revelc.code.formatter.xml.XMLFormatter;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.resource.ResourceManager;
import org.codehaus.plexus.resource.loader.ResourceNotFoundException;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.WriterFactory;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.text.edits.MalformedTreeException;
import org.xml.sax.SAXException;

@Mojo(name="format", defaultPhase=LifecyclePhase.PROCESS_SOURCES, requiresProject=true, threadSafe=true)
public class FormatterMojo
extends AbstractMojo
implements ConfigurationSource {
    private static final String FILE_S = " file(s)";
    private static final String CACHE_PROPERTIES_FILENAME = "formatter-maven-cache.properties";
    private static final String[] DEFAULT_INCLUDES = new String[]{"**/*.css", "**/*.json", "**/*.html", "**/*.java", "**/*.js", "**/*.xml"};
    @Component(role=ResourceManager.class)
    private ResourceManager resourceManager;
    @Parameter(defaultValue="${project.build.sourceDirectory}", property="sourceDirectory", required=true)
    private File sourceDirectory;
    @Parameter(defaultValue="${project.build.testSourceDirectory}", property="testSourceDirectory", required=true)
    private File testSourceDirectory;
    @Parameter(defaultValue="${project.build.directory}", readonly=true, required=true)
    private File targetDirectory;
    @Parameter(defaultValue=".", property="project.basedir", readonly=true, required=true)
    private File basedir;
    @Parameter(defaultValue="${project.build.directory}", property="formatter.cachedir")
    private File cachedir;
    @Parameter
    private File[] directories;
    @Parameter(property="formatter.includes")
    private String[] includes;
    @Parameter(property="formatter.excludes")
    private String[] excludes;
    @Parameter(defaultValue="1.8", property="maven.compiler.source", required=true)
    private String compilerSource;
    @Parameter(defaultValue="1.8", property="maven.compiler.source", required=true)
    private String compilerCompliance;
    @Parameter(defaultValue="1.8", property="maven.compiler.target", required=true)
    private String compilerTargetPlatform;
    @Parameter(property="project.build.sourceEncoding", required=true)
    private String encoding;
    @Parameter(defaultValue="AUTO", property="lineending", required=true)
    private LineEnding lineEnding;
    @Parameter(defaultValue="formatter-maven-plugin/eclipse/java.xml", property="configfile", required=true)
    private String configFile;
    @Parameter(defaultValue="formatter-maven-plugin/eclipse/javascript.xml", property="configjsfile", required=true)
    private String configJsFile;
    @Parameter(defaultValue="formatter-maven-plugin/jsoup/html.properties", property="confightmlfile", required=true)
    private String configHtmlFile;
    @Parameter(defaultValue="formatter-maven-plugin/eclipse/xml.properties", property="configxmlfile", required=true)
    private String configXmlFile;
    @Parameter(defaultValue="formatter-maven-plugin/jackson/json.properties", property="configjsonfile", required=true)
    private String configJsonFile;
    @Parameter(defaultValue="formatter-maven-plugin/ph-css/css.properties", property="configcssfile", required=true)
    private String configCssFile;
    @Parameter(defaultValue="false", property="formatter.java.skip")
    private boolean skipJavaFormatting;
    @Parameter(defaultValue="false", property="formatter.js.skip")
    private boolean skipJsFormatting;
    @Parameter(defaultValue="false", property="formatter.html.skip")
    private boolean skipHtmlFormatting;
    @Parameter(defaultValue="false", property="formatter.xml.skip")
    private boolean skipXmlFormatting;
    @Parameter(defaultValue="false", property="formatter.json.skip")
    private boolean skipJsonFormatting;
    @Parameter(defaultValue="false", property="formatter.css.skip")
    private boolean skipCssFormatting;
    @Parameter(defaultValue="false", alias="skip", property="formatter.skip")
    private boolean skipFormatting;
    @Parameter(defaultValue="false", property="formatter.useEclipseDefaults")
    private boolean useEclipseDefaults;
    private JavaFormatter javaFormatter = new JavaFormatter();
    private JavascriptFormatter jsFormatter = new JavascriptFormatter();
    private HTMLFormatter htmlFormatter = new HTMLFormatter();
    private XMLFormatter xmlFormatter = new XMLFormatter();
    private JsonFormatter jsonFormatter = new JsonFormatter();
    private CssFormatter cssFormatter = new CssFormatter();
    private boolean hashCacheWritten;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skipFormatting) {
            this.getLog().info((CharSequence)"Formatting is skipped");
            return;
        }
        long startClock = System.currentTimeMillis();
        if (StringUtils.isEmpty((String)this.encoding)) {
            this.encoding = ReaderFactory.FILE_ENCODING;
            this.getLog().warn((CharSequence)("File encoding has not been set, using platform encoding (" + this.encoding + ") to format source files, i.e. build is platform dependent!"));
        } else {
            if (!Charset.isSupported(this.encoding)) {
                throw new MojoExecutionException("Encoding '" + this.encoding + "' is not supported");
            }
            this.getLog().info((CharSequence)("Using '" + this.encoding + "' encoding to format source files."));
        }
        ArrayList<File> files = new ArrayList<File>();
        if (this.directories != null) {
            for (File directory : this.directories) {
                if (!directory.exists() || !directory.isDirectory()) continue;
                files.addAll(this.addCollectionFiles(directory));
            }
        } else {
            if (this.sourceDirectory != null && this.sourceDirectory.exists() && this.sourceDirectory.isDirectory()) {
                files.addAll(this.addCollectionFiles(this.sourceDirectory));
            }
            if (this.testSourceDirectory != null && this.testSourceDirectory.exists() && this.testSourceDirectory.isDirectory()) {
                files.addAll(this.addCollectionFiles(this.testSourceDirectory));
            }
        }
        int numberOfFiles = files.size();
        Log log = this.getLog();
        log.info((CharSequence)("Number of files to be formatted: " + numberOfFiles));
        if (numberOfFiles > 0) {
            this.createCodeFormatter();
            ResultCollector rc = new ResultCollector();
            Properties hashCache = this.readFileHashCacheFile();
            String basedirPath = this.getBasedirPath();
            int n = files.size();
            for (int i = 0; i < n; ++i) {
                File file = (File)files.get(i);
                if (file.exists()) {
                    if (file.canWrite()) {
                        this.formatFile(file, rc, hashCache, basedirPath);
                        continue;
                    }
                    ++rc.readOnlyCount;
                    continue;
                }
                ++rc.failCount;
            }
            if (this.hashCacheWritten) {
                this.storeFileHashCache(hashCache);
            }
            long endClock = System.currentTimeMillis();
            log.info((CharSequence)("Successfully formatted:          " + rc.successCount + FILE_S));
            log.info((CharSequence)("Fail to format:                  " + rc.failCount + FILE_S));
            log.info((CharSequence)("Skipped:                         " + rc.skippedCount + FILE_S));
            log.info((CharSequence)("Read only skipped:               " + rc.readOnlyCount + FILE_S));
            log.info((CharSequence)("Approximate time taken:          " + (endClock - startClock) / 1000L + "s"));
        }
    }

    List<File> addCollectionFiles(File newBasedir) {
        DirectoryScanner ds = new DirectoryScanner();
        ds.setBasedir(newBasedir);
        if (this.includes != null && this.includes.length > 0) {
            ds.setIncludes(this.includes);
        } else {
            ds.setIncludes(DEFAULT_INCLUDES);
        }
        ds.setExcludes(this.excludes);
        ds.addDefaultExcludes();
        ds.setCaseSensitive(false);
        ds.setFollowSymlinks(false);
        ds.scan();
        ArrayList<File> foundFiles = new ArrayList<File>();
        for (String filename : ds.getIncludedFiles()) {
            foundFiles.add(new File(newBasedir, filename));
        }
        return foundFiles;
    }

    private String getBasedirPath() {
        try {
            return this.basedir.getCanonicalPath();
        }
        catch (IOException e) {
            this.getLog().debug((CharSequence)"", (Throwable)e);
            return "";
        }
    }

    private void storeFileHashCache(Properties props) {
        File cacheFile = new File(this.cachedir, CACHE_PROPERTIES_FILENAME);
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(cacheFile));){
            props.store(out, null);
        }
        catch (IOException e) {
            this.getLog().warn((CharSequence)"Cannot store file hash cache properties file", (Throwable)e);
        }
    }

    private Properties readFileHashCacheFile() {
        Properties props = new Properties();
        Log log = this.getLog();
        if (!this.cachedir.exists()) {
            this.cachedir.mkdirs();
        } else if (!this.cachedir.isDirectory()) {
            log.warn((CharSequence)("Something strange here as the '" + this.cachedir.getPath() + "' supposedly cache directory is not a directory."));
            return props;
        }
        File cacheFile = new File(this.cachedir, CACHE_PROPERTIES_FILENAME);
        if (!cacheFile.exists()) {
            return props;
        }
        try (BufferedInputStream stream = new BufferedInputStream(new FileInputStream(cacheFile));){
            props.load(stream);
        }
        catch (IOException e) {
            log.warn((CharSequence)"Cannot load file hash cache properties file", (Throwable)e);
        }
        return props;
    }

    private void formatFile(File file, ResultCollector rc, Properties hashCache, String basedirPath) throws MojoFailureException, MojoExecutionException {
        try {
            this.doFormatFile(file, rc, hashCache, basedirPath, false);
        }
        catch (IOException | BadLocationException | MalformedTreeException e) {
            ++rc.failCount;
            this.getLog().warn(e);
        }
    }

    protected void doFormatFile(File file, ResultCollector rc, Properties hashCache, String basedirPath, boolean dryRun) throws IOException, BadLocationException, MojoFailureException, MojoExecutionException {
        Log log = this.getLog();
        log.debug((CharSequence)("Processing file: " + file));
        String originalCode = this.readFileAsString(file);
        String originalHash = this.sha512hash(originalCode);
        String canonicalPath = file.getCanonicalPath();
        String path = canonicalPath.substring(basedirPath.length());
        String cachedHash = hashCache.getProperty(path);
        if (cachedHash != null && cachedHash.equals(originalHash)) {
            ++rc.skippedCount;
            log.debug((CharSequence)"File is already formatted.");
            return;
        }
        Result result = null;
        String formattedCode = null;
        if (file.getName().endsWith(".java") && this.javaFormatter.isInitialized()) {
            if (this.skipJavaFormatting) {
                this.getLog().info((CharSequence)"Java formatting is skipped");
                result = Result.SKIPPED;
            } else {
                formattedCode = this.javaFormatter.formatFile(file, originalCode, this.lineEnding);
            }
        } else if (file.getName().endsWith(".js") && this.jsFormatter.isInitialized()) {
            if (this.skipJsFormatting) {
                this.getLog().info((CharSequence)"Javascript formatting is skipped");
                result = Result.SKIPPED;
            } else {
                formattedCode = this.jsFormatter.formatFile(file, originalCode, this.lineEnding);
            }
        } else if (file.getName().endsWith(".html") && this.htmlFormatter.isInitialized()) {
            if (this.skipHtmlFormatting) {
                this.getLog().info((CharSequence)"Html formatting is skipped");
                result = Result.SKIPPED;
            } else {
                formattedCode = this.htmlFormatter.formatFile(file, originalCode, this.lineEnding);
            }
        } else if (file.getName().endsWith(".xml") && this.xmlFormatter.isInitialized()) {
            if (this.skipXmlFormatting) {
                this.getLog().info((CharSequence)"Xml formatting is skipped");
                result = Result.SKIPPED;
            } else {
                formattedCode = this.xmlFormatter.formatFile(file, originalCode, this.lineEnding);
            }
        } else if (file.getName().endsWith(".json") && this.jsonFormatter.isInitialized()) {
            if (this.skipJsonFormatting) {
                this.getLog().info((CharSequence)"json formatting is skipped");
                result = Result.SKIPPED;
            } else {
                formattedCode = this.jsonFormatter.formatFile(file, originalCode, this.lineEnding);
            }
        } else if (file.getName().endsWith(".css") && this.cssFormatter.isInitialized()) {
            if (this.skipCssFormatting) {
                this.getLog().info((CharSequence)"css formatting is skipped");
                result = Result.SKIPPED;
            } else {
                formattedCode = this.cssFormatter.formatFile(file, originalCode, this.lineEnding);
            }
        } else {
            log.debug((CharSequence)("No formatter found or initialization failed for file " + file.getName()));
            result = Result.SKIPPED;
        }
        if (!Result.SKIPPED.equals((Object)result)) {
            result = formattedCode == null ? Result.FAIL : (originalCode.equals(formattedCode) ? Result.SKIPPED : Result.SUCCESS);
        }
        if (Result.SKIPPED.equals((Object)result)) {
            ++rc.skippedCount;
        } else if (Result.SUCCESS.equals((Object)result)) {
            ++rc.successCount;
        } else if (Result.FAIL.equals((Object)result)) {
            ++rc.failCount;
            return;
        }
        String formattedHash = Result.SKIPPED.equals((Object)result) ? originalHash : this.sha512hash(Strings.nullToEmpty((String)formattedCode));
        hashCache.setProperty(path, formattedHash);
        this.hashCacheWritten = true;
        if (Result.SKIPPED.equals((Object)result)) {
            log.debug((CharSequence)"File is already formatted.  Writing to cache only.");
            return;
        }
        if (originalHash.equals(formattedHash)) {
            ++rc.skippedCount;
            log.debug((CharSequence)"Equal hash code. Not writing result to file.");
            return;
        }
        if (!dryRun) {
            this.writeStringToFile(formattedCode, file);
        }
    }

    private String sha512hash(String str) {
        return Hashing.sha512().hashBytes(str.getBytes(this.getEncoding())).toString();
    }

    private String readFileAsString(File file) throws IOException {
        StringBuilder fileData = new StringBuilder(1000);
        try (BufferedReader reader = new BufferedReader(ReaderFactory.newReader((File)file, (String)this.encoding));){
            char[] buf = new char[1024];
            int numRead = 0;
            while ((numRead = reader.read(buf)) != -1) {
                String readData = String.valueOf(buf, 0, numRead);
                fileData.append(readData);
                buf = new char[1024];
            }
        }
        return fileData.toString();
    }

    private void writeStringToFile(String str, File file) throws IOException {
        if (!file.exists() && file.isDirectory()) {
            return;
        }
        try (BufferedWriter bw = new BufferedWriter(WriterFactory.newWriter((File)file, (String)this.encoding));){
            bw.write(str);
        }
    }

    private void createCodeFormatter() throws MojoExecutionException {
        Map<String, String> jsFormattingOptions;
        Map<String, String> javaFormattingOptions = this.getFormattingOptions(this.configFile);
        if (javaFormattingOptions != null) {
            this.javaFormatter.init(javaFormattingOptions, this);
        }
        if ((jsFormattingOptions = this.getFormattingOptions(this.configJsFile)) != null) {
            this.jsFormatter.init(jsFormattingOptions, this);
        }
        if (this.configHtmlFile != null) {
            this.htmlFormatter.init(this.getOptionsFromPropertiesFile(this.configHtmlFile), this);
        }
        if (this.configXmlFile != null) {
            Map<String, String> xmlFormattingOptions = this.getOptionsFromPropertiesFile(this.configXmlFile);
            xmlFormattingOptions.put("lineending", this.lineEnding.getChars());
            this.xmlFormatter.init(xmlFormattingOptions, this);
        }
        if (this.configJsonFile != null) {
            Map<String, String> jsonFormattingOptions = this.getOptionsFromPropertiesFile(this.configJsonFile);
            jsonFormattingOptions.put("lineending", this.lineEnding.getChars());
            this.jsonFormatter.init(jsonFormattingOptions, this);
        }
        if (this.configCssFile != null) {
            this.cssFormatter.init(this.getOptionsFromPropertiesFile(this.configCssFile), this);
        }
        if (javaFormattingOptions == null && jsFormattingOptions == null && this.configHtmlFile == null && this.configXmlFile == null && this.configCssFile == null) {
            throw new MojoExecutionException("You must provide a Java, Javascript, HTML, XML, JSON, or CSS configuration file.");
        }
    }

    private Map<String, String> getFormattingOptions(String newConfigFile) throws MojoExecutionException {
        if (this.useEclipseDefaults) {
            this.getLog().info((CharSequence)"Using Ecipse Defaults");
            HashMap<String, String> options = new HashMap<String, String>();
            options.put("org.eclipse.jdt.core.compiler.source", this.compilerSource);
            options.put("org.eclipse.jdt.core.compiler.compliance", this.compilerCompliance);
            options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", this.compilerTargetPlatform);
            return options;
        }
        return this.getOptionsFromConfigFile(newConfigFile);
    }

    private Map<String, String> getOptionsFromConfigFile(String newConfigFile) throws MojoExecutionException {
        Map<String, String> map;
        block11: {
            this.getLog().debug((CharSequence)("Using search path at: " + this.basedir.getAbsolutePath()));
            this.resourceManager.addSearchPath("file", this.basedir.getAbsolutePath());
            InputStream configInput = this.resourceManager.getResourceAsInputStream(newConfigFile);
            try {
                map = new ConfigReader().read(configInput);
                if (configInput == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (configInput != null) {
                        try {
                            configInput.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ResourceNotFoundException e) {
                    throw new MojoExecutionException("Cannot find config file [" + newConfigFile + "]");
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Cannot read config file [" + newConfigFile + "]", (Exception)e);
                }
                catch (SAXException e) {
                    throw new MojoExecutionException("Cannot parse config file [" + newConfigFile + "]", (Exception)e);
                }
                catch (ConfigReadException e) {
                    throw new MojoExecutionException(e.getMessage(), (Exception)e);
                }
            }
            configInput.close();
        }
        return map;
    }

    private Map<String, String> getOptionsFromPropertiesFile(String newPropertiesFile) throws MojoExecutionException {
        this.getLog().debug((CharSequence)("Using search path at: " + this.basedir.getAbsolutePath()));
        this.resourceManager.addSearchPath("file", this.basedir.getAbsolutePath());
        Properties properties = new Properties();
        try {
            properties.load(this.resourceManager.getResourceAsInputStream(newPropertiesFile));
        }
        catch (ResourceNotFoundException e) {
            this.getLog().debug((CharSequence)("Property file [" + newPropertiesFile + "] cannot be found"), (Throwable)e);
            return new HashMap<String, String>();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Cannot read config file [" + newPropertiesFile + "]", (Exception)e);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (String name : properties.stringPropertyNames()) {
            map.put(name, properties.getProperty(name));
        }
        return map;
    }

    @Override
    public String getCompilerSources() {
        return this.compilerSource;
    }

    @Override
    public String getCompilerCompliance() {
        return this.compilerCompliance;
    }

    @Override
    public String getCompilerCodegenTargetPlatform() {
        return this.compilerTargetPlatform;
    }

    @Override
    public File getTargetDirectory() {
        return this.targetDirectory;
    }

    @Override
    public Charset getEncoding() {
        return Charset.forName(this.encoding);
    }

    class ResultCollector {
        int successCount;
        int failCount;
        int skippedCount;
        int readOnlyCount;

        ResultCollector() {
        }
    }
}

