/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Set;
import org.jclouds.cloudstack.domain.IngressRule;
import org.jclouds.cloudstack.domain.Tag;
import org.jclouds.javax.annotation.Nullable;

public class SecurityGroup
implements Comparable<SecurityGroup> {
    private final String id;
    private final String account;
    private final String name;
    private final String description;
    private final String domain;
    private final String domainId;
    private final String jobId;
    private final Integer jobStatus;
    private final Set<IngressRule> ingressRules;
    private final Set<Tag> tags;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromSecurityGroup(this);
    }

    @ConstructorProperties(value={"id", "account", "name", "description", "domain", "domainid", "jobid", "jobstatus", "ingressrule", "tags"})
    protected SecurityGroup(String id, @Nullable String account, @Nullable String name, @Nullable String description, @Nullable String domain, @Nullable String domainId, @Nullable String jobId, @Nullable Integer jobStatus, @Nullable Set<IngressRule> ingressRules, @Nullable Set<Tag> tags) {
        this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id");
        this.account = account;
        this.name = name;
        this.description = description;
        this.domain = domain;
        this.domainId = domainId;
        this.jobId = jobId;
        this.jobStatus = jobStatus;
        this.ingressRules = ingressRules == null ? ImmutableSet.of() : ImmutableSortedSet.copyOf(ingressRules);
        this.tags = tags != null ? ImmutableSet.copyOf(tags) : ImmutableSet.of();
    }

    public String getId() {
        return this.id;
    }

    @Nullable
    public String getAccount() {
        return this.account;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Nullable
    public String getDomain() {
        return this.domain;
    }

    @Nullable
    public String getDomainId() {
        return this.domainId;
    }

    @Nullable
    public String getJobId() {
        return this.jobId;
    }

    @Nullable
    public Integer getJobStatus() {
        return this.jobStatus;
    }

    public Set<IngressRule> getIngressRules() {
        return this.ingressRules;
    }

    public Set<Tag> getTags() {
        return this.tags;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.account, this.name, this.description, this.domain, this.domainId, this.jobId, this.jobStatus, this.ingressRules, this.tags});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SecurityGroup that = (SecurityGroup)SecurityGroup.class.cast(obj);
        return Objects.equal((Object)this.id, (Object)that.id) && Objects.equal((Object)this.account, (Object)that.account) && Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.description, (Object)that.description) && Objects.equal((Object)this.domain, (Object)that.domain) && Objects.equal((Object)this.domainId, (Object)that.domainId) && Objects.equal((Object)this.jobId, (Object)that.jobId) && Objects.equal((Object)this.jobStatus, (Object)that.jobStatus) && Objects.equal(this.ingressRules, that.ingressRules) && Objects.equal(this.tags, that.tags);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((Object)this).add("id", (Object)this.id).add("account", (Object)this.account).add("name", (Object)this.name).add("description", (Object)this.description).add("domain", (Object)this.domain).add("domainId", (Object)this.domainId).add("jobId", (Object)this.jobId).add("jobStatus", (Object)this.jobStatus).add("ingressRules", this.ingressRules).add("tags", this.tags);
    }

    public String toString() {
        return this.string().toString();
    }

    @Override
    public int compareTo(SecurityGroup o) {
        return this.id.compareTo(o.getId());
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String id;
        protected String account;
        protected String name;
        protected String description;
        protected String domain;
        protected String domainId;
        protected String jobId;
        protected Integer jobStatus;
        protected Set<IngressRule> ingressRules;
        protected Set<Tag> tags = ImmutableSet.of();

        protected abstract T self();

        public T id(String id) {
            this.id = id;
            return this.self();
        }

        public T account(String account) {
            this.account = account;
            return this.self();
        }

        public T name(String name) {
            this.name = name;
            return this.self();
        }

        public T description(String description) {
            this.description = description;
            return this.self();
        }

        public T domain(String domain) {
            this.domain = domain;
            return this.self();
        }

        public T domainId(String domainId) {
            this.domainId = domainId;
            return this.self();
        }

        public T jobId(String jobId) {
            this.jobId = jobId;
            return this.self();
        }

        public T jobStatus(Integer jobStatus) {
            this.jobStatus = jobStatus;
            return this.self();
        }

        public T ingressRules(Set<IngressRule> ingressRules) {
            this.ingressRules = ingressRules;
            return this.self();
        }

        public T tags(Set<Tag> tags) {
            this.tags = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(tags, (Object)"tags")));
            return this.self();
        }

        public T tags(Tag ... in) {
            return this.tags((Set<Tag>)ImmutableSet.copyOf((Object[])in));
        }

        public SecurityGroup build() {
            return new SecurityGroup(this.id, this.account, this.name, this.description, this.domain, this.domainId, this.jobId, this.jobStatus, this.ingressRules, this.tags);
        }

        public T fromSecurityGroup(SecurityGroup in) {
            return ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)this.id(in.getId())).account(in.getAccount())).name(in.getName())).description(in.getDescription())).domain(in.getDomain())).domainId(in.getDomainId())).jobId(in.getJobId())).jobStatus(in.getJobStatus())).ingressRules(in.getIngressRules())).tags(in.getTags());
        }
    }
}

