/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.cloudidentity.v2_0;

import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.util.Properties;
import java.util.Set;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.openstack.keystone.v2_0.KeystoneApiMetadata;
import org.jclouds.openstack.keystone.v2_0.config.KeystoneHttpApiModule;
import org.jclouds.openstack.keystone.v2_0.config.KeystoneParserModule;
import org.jclouds.rackspace.cloudidentity.v2_0.config.CloudIdentityAuthenticationApiModule;
import org.jclouds.rackspace.cloudidentity.v2_0.config.CloudIdentityAuthenticationModule;

@AutoService(value=ApiMetadata.class)
public class CloudIdentityApiMetadata
extends KeystoneApiMetadata {
    public Builder toBuilder() {
        return (Builder)new Builder().fromApiMetadata((ApiMetadata)this);
    }

    public CloudIdentityApiMetadata() {
        this(new Builder());
    }

    protected CloudIdentityApiMetadata(Builder builder) {
        super((KeystoneApiMetadata.Builder)builder);
    }

    public static Properties defaultProperties() {
        Properties properties = KeystoneApiMetadata.defaultProperties();
        properties.setProperty("jclouds.keystone.credential-type", "RAX-KSKEY:apiKeyCredentials");
        return properties;
    }

    public static class Builder
    extends KeystoneApiMetadata.Builder<Builder> {
        protected Builder() {
            ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)this.id("rackspace-cloudidentity")).name("Rackspace Cloud Identity Service")).identityName("${userName}")).credentialName("${apiKey}")).defaultEndpoint("https://identity.api.rackspacecloud.com/v${jclouds.api-version}/")).endpointName("identity service url ending in /v${jclouds.api-version}/")).defaultProperties(CloudIdentityApiMetadata.defaultProperties())).documentation(URI.create("http://docs.rackspace.com/auth/api/v2.0/auth-api-devguide/"))).defaultModules((Set)ImmutableSet.builder().add(CloudIdentityAuthenticationApiModule.class).add(CloudIdentityAuthenticationModule.class).add(KeystoneHttpApiModule.KeystoneAdminURLModule.class).add(KeystoneParserModule.class).add(KeystoneHttpApiModule.class).build());
        }

        public CloudIdentityApiMetadata build() {
            return new CloudIdentityApiMetadata(this);
        }

        protected Builder self() {
            return this;
        }
    }
}

