/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.location.suppliers.all;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.domain.Location;
import org.jclouds.domain.LocationBuilder;
import org.jclouds.domain.LocationScope;
import org.jclouds.location.Iso3166;
import org.jclouds.location.Zone;
import org.jclouds.location.predicates.LocationPredicates;
import org.jclouds.location.suppliers.LocationsSupplier;
import org.jclouds.location.suppliers.all.RegionToProviderOrJustProvider;
import org.jclouds.logging.Logger;

@Singleton
public class ZoneToRegionToProviderOrJustProvider
implements LocationsSupplier {
    @Resource
    protected Logger logger = Logger.NULL;
    private final RegionToProviderOrJustProvider regionToProviderOrJustProvider;
    private final Supplier<Set<String>> zoneIdsSupplier;
    private final Supplier<Map<String, Supplier<Set<String>>>> isoCodesByIdSupplier;
    private final Supplier<Map<String, Supplier<Set<String>>>> regionIdToZoneIdsSupplier;

    @Inject
    ZoneToRegionToProviderOrJustProvider(RegionToProviderOrJustProvider regionToProviderOrJustProvider, @Zone Supplier<Set<String>> zoneIdsSupplier, @Iso3166 Supplier<Map<String, Supplier<Set<String>>>> isoCodesByIdSupplier, @Zone Supplier<Map<String, Supplier<Set<String>>>> regionIdToZoneIdsSupplier) {
        this.regionToProviderOrJustProvider = (RegionToProviderOrJustProvider)Preconditions.checkNotNull((Object)regionToProviderOrJustProvider, (Object)"regionToProviderOrJustProvider");
        this.zoneIdsSupplier = (Supplier)Preconditions.checkNotNull(zoneIdsSupplier, (Object)"zoneIdsSupplier");
        this.regionIdToZoneIdsSupplier = (Supplier)Preconditions.checkNotNull(regionIdToZoneIdsSupplier, (Object)"regionIdToZoneIdsSupplier");
        this.isoCodesByIdSupplier = (Supplier)Preconditions.checkNotNull(isoCodesByIdSupplier, (Object)"isoCodesByIdSupplier");
    }

    public Set<? extends Location> get() {
        Object regionsOrJustProvider = this.regionToProviderOrJustProvider.get();
        Set zoneIds = (Set)this.zoneIdsSupplier.get();
        if (zoneIds.isEmpty()) {
            return regionsOrJustProvider;
        }
        Map<String, Location> zoneIdToParent = this.setParentOfZoneToRegionOrProvider(zoneIds, (Set<? extends Location>)regionsOrJustProvider);
        Map isoCodesById = (Map)this.isoCodesByIdSupplier.get();
        ImmutableSet.Builder locations = ImmutableSet.builder();
        if (!Iterables.all((Iterable)regionsOrJustProvider, LocationPredicates.isProvider())) {
            locations.addAll((Iterable)regionsOrJustProvider);
        }
        for (Map.Entry<String, Location> entry : zoneIdToParent.entrySet()) {
            String zoneId = entry.getKey();
            Location parent = entry.getValue();
            LocationBuilder builder = new LocationBuilder().scope(LocationScope.ZONE).id(zoneId).description(zoneId).parent(parent);
            if (isoCodesById.containsKey(zoneId)) {
                builder.iso3166Codes((Iterable)((Supplier)isoCodesById.get(zoneId)).get());
            } else if (parent.getScope() == LocationScope.REGION) {
                builder.iso3166Codes(parent.getIso3166Codes());
            }
            locations.add((Object)builder.build());
        }
        return locations.build();
    }

    private Map<String, Location> setParentOfZoneToRegionOrProvider(Set<String> zoneIds, Set<? extends Location> locations) {
        Sets.SetView orphans;
        LinkedHashMap zoneIdToParent = Maps.newLinkedHashMap();
        Location provider = (Location)Iterables.find(locations, LocationPredicates.isProvider(), null);
        if (locations.size() == 1 && provider != null) {
            for (String zone : zoneIds) {
                zoneIdToParent.put(zone, provider);
            }
        } else {
            Map regionIdToZoneIds = (Map)this.regionIdToZoneIdsSupplier.get();
            for (Location region : Iterables.filter(locations, LocationPredicates.isRegion())) {
                provider = region.getParent();
                if (regionIdToZoneIds.containsKey(region.getId())) {
                    for (String zoneId : (Set)((Supplier)regionIdToZoneIds.get(region.getId())).get()) {
                        zoneIdToParent.put(zoneId, region);
                    }
                    continue;
                }
                this.logger.debug("no zones configured for region: %s", region);
            }
        }
        if (!(orphans = Sets.difference(zoneIds, zoneIdToParent.keySet())).isEmpty()) {
            Preconditions.checkState((provider != null ? 1 : 0) != 0, (String)"cannot configure zones %s as we need a parent, and the only available location [%s] is not a provider", (Object[])new Object[]{zoneIds, locations});
            for (String orphanedZoneId : orphans) {
                zoneIdToParent.put(orphanedZoneId, provider);
            }
        }
        Preconditions.checkState((boolean)zoneIdToParent.keySet().containsAll(zoneIds), (String)"orphaned zones: %s ", (Object[])new Object[]{Sets.difference(zoneIds, zoneIdToParent.keySet())});
        return zoneIdToParent;
    }
}

