/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine;

import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.util.Properties;
import java.util.Set;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.googlecomputeengine.GoogleComputeEngineApi;
import org.jclouds.googlecomputeengine.compute.config.GoogleComputeEngineServiceContextModule;
import org.jclouds.googlecomputeengine.config.GoogleComputeEngineHttpApiModule;
import org.jclouds.googlecomputeengine.config.GoogleComputeEngineParserModule;
import org.jclouds.oauth.v2.config.OAuthModule;
import org.jclouds.reflect.Reflection2;
import org.jclouds.rest.internal.BaseHttpApiMetadata;

public class GoogleComputeEngineApiMetadata
extends BaseHttpApiMetadata<GoogleComputeEngineApi> {
    public Builder toBuilder() {
        return (Builder)new Builder().fromApiMetadata((ApiMetadata)this);
    }

    public GoogleComputeEngineApiMetadata() {
        this(new Builder());
    }

    protected GoogleComputeEngineApiMetadata(Builder builder) {
        super((BaseHttpApiMetadata.Builder)builder);
    }

    public static Properties defaultProperties() {
        Properties properties = BaseHttpApiMetadata.defaultProperties();
        properties.put("oauth.endpoint", "https://accounts.google.com/o/oauth2/token");
        properties.put("jclouds.oauth.audience", "https://accounts.google.com/o/oauth2/token");
        properties.put("jclouds.oauth.jws-alg", "RS256");
        properties.put("jclouds.session-interval", (Object)3600);
        properties.put("jclouds.google-compute-engine.operation-complete-interval", (Object)500);
        properties.put("jclouds.google-compute-engine.operation-complete-timeout", (Object)600000);
        properties.put("jclouds.template", "osFamily=DEBIAN,osVersionMatches=7\\..*,locationId=us-central1-a");
        properties.put("jclouds.googlecloud.project-name", "");
        properties.put("jclouds.google-compute-engine.image-projects", "centos-cloud,debian-cloud,rhel-cloud,suse-cloud,opensuse-cloud,gce-nvme,coreos-cloud,ubuntu-os-cloud,windows-cloud");
        return properties;
    }

    public static class Builder
    extends BaseHttpApiMetadata.Builder<GoogleComputeEngineApi, Builder> {
        protected Builder() {
            ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)this.id("google-compute-engine")).name("Google Compute Engine Api")).identityName("client_email which usually looks like project_id@developer.gserviceaccount.com or project_id-extended_uid@developer.gserviceaccount.com")).credentialName("PEM encoded P12 private key associated with client_email")).documentation(URI.create("https://developers.google.com/compute/docs"))).version("v1")).defaultEndpoint("https://www.googleapis.com/compute/v1")).defaultProperties(GoogleComputeEngineApiMetadata.defaultProperties())).view(Reflection2.typeToken(ComputeServiceContext.class))).defaultModules((Set)ImmutableSet.builder().add(GoogleComputeEngineHttpApiModule.class).add(GoogleComputeEngineParserModule.class).add(OAuthModule.class).add(GoogleComputeEngineServiceContextModule.class).build());
        }

        public GoogleComputeEngineApiMetadata build() {
            return new GoogleComputeEngineApiMetadata(this);
        }

        protected Builder self() {
            return this;
        }
    }
}

