/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.util.concurrent.Atomics;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import org.jclouds.googlecomputeengine.GoogleComputeEngineApi;
import org.jclouds.googlecomputeengine.compute.domain.NetworkAndAddressRange;
import org.jclouds.googlecomputeengine.domain.Network;
import org.jclouds.googlecomputeengine.domain.Operation;
import org.jclouds.googlecomputeengine.options.NetworkCreationOptions;

public final class CreateNetworkIfNeeded
implements Function<NetworkAndAddressRange, Network> {
    private final GoogleComputeEngineApi api;
    private final Predicate<AtomicReference<Operation>> operationDone;

    @Inject
    CreateNetworkIfNeeded(GoogleComputeEngineApi api, Predicate<AtomicReference<Operation>> operationDone) {
        this.api = api;
        this.operationDone = operationDone;
    }

    public Network apply(NetworkAndAddressRange input) {
        Preconditions.checkNotNull((Object)input, (Object)"input");
        Network nw = this.api.networks().get(input.name());
        if (nw != null) {
            return nw;
        }
        if (input.gateway() != null) {
            NetworkCreationOptions options = new NetworkCreationOptions.Builder(input.name(), input.rangeIPv4()).gatewayIPv4(input.gateway()).build();
            AtomicReference operation = Atomics.newReference((Object)this.api.networks().createInIPv4Range(options));
            this.operationDone.apply((Object)operation);
            Preconditions.checkState((((Operation)operation.get()).httpErrorStatusCode() == null ? 1 : 0) != 0, (Object)("Could not insert network, operation failed" + operation));
        } else {
            AtomicReference operation = Atomics.newReference((Object)this.api.networks().createInIPv4Range(input.name(), input.rangeIPv4()));
            this.operationDone.apply((Object)operation);
            Preconditions.checkState((((Operation)operation.get()).httpErrorStatusCode() == null ? 1 : 0) != 0, (Object)("Could not insert network, operation failed" + operation));
        }
        return (Network)Preconditions.checkNotNull((Object)this.api.networks().get(input.name()), (String)"no network with name %s was found", (Object[])new Object[]{input.name()});
    }
}

