/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.joyent.cloudapi.v6_5.compute;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.Atomics;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import org.jclouds.compute.ComputeServiceAdapter;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.compute.reference.ComputeServiceConstants;
import org.jclouds.compute.util.ComputeServiceUtils;
import org.jclouds.domain.Location;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.joyent.cloudapi.v6_5.JoyentCloudApi;
import org.jclouds.joyent.cloudapi.v6_5.domain.Dataset;
import org.jclouds.joyent.cloudapi.v6_5.domain.Machine;
import org.jclouds.joyent.cloudapi.v6_5.domain.Package;
import org.jclouds.joyent.cloudapi.v6_5.domain.datacenterscoped.DatacenterAndId;
import org.jclouds.joyent.cloudapi.v6_5.domain.datacenterscoped.DatasetInDatacenter;
import org.jclouds.joyent.cloudapi.v6_5.domain.datacenterscoped.MachineInDatacenter;
import org.jclouds.joyent.cloudapi.v6_5.domain.datacenterscoped.PackageInDatacenter;
import org.jclouds.joyent.cloudapi.v6_5.options.CreateMachineOptions;
import org.jclouds.location.Zone;
import org.jclouds.logging.Logger;
import org.jclouds.util.Predicates2;

public class JoyentCloudComputeServiceAdapter
implements ComputeServiceAdapter<MachineInDatacenter, PackageInDatacenter, DatasetInDatacenter, Location> {
    @Resource
    @Named(value="jclouds.compute")
    private Logger logger = Logger.NULL;
    private final JoyentCloudApi cloudApiApi;
    private final Supplier<Set<String>> datacenterIds;
    private final ComputeServiceConstants.Timeouts timeouts;

    @Inject
    public JoyentCloudComputeServiceAdapter(JoyentCloudApi cloudApiApi, @Zone Supplier<Set<String>> datacenterIds, ComputeServiceConstants.Timeouts timeouts) {
        this.cloudApiApi = (JoyentCloudApi)Preconditions.checkNotNull((Object)cloudApiApi, (Object)"cloudApiApi");
        this.datacenterIds = (Supplier)Preconditions.checkNotNull(datacenterIds, (Object)"datacenterIds");
        this.timeouts = (ComputeServiceConstants.Timeouts)Preconditions.checkNotNull((Object)timeouts, (Object)"timeouts");
    }

    public ComputeServiceAdapter.NodeAndInitialCredentials<MachineInDatacenter> createNodeWithGroupEncodedIntoName(String group, String name, Template template) {
        LoginCredentials.Builder credentialsBuilder = LoginCredentials.builder();
        CreateMachineOptions options = new CreateMachineOptions();
        options.name(name);
        options.packageName(template.getHardware().getProviderId());
        options.metadata(ComputeServiceUtils.metadataAndTagsAsCommaDelimitedValue((TemplateOptions)template.getOptions()));
        String datacenterId = template.getLocation().getId();
        String datasetURN = template.getImage().getProviderId();
        this.logger.debug(">> creating new machine datacenter(%s) datasetURN(%s) options(%s)", new Object[]{datacenterId, datasetURN, options});
        Machine machine = this.cloudApiApi.getMachineApiForDatacenter(datacenterId).createWithDataset(datasetURN, options);
        this.logger.trace("<< machine(%s)", new Object[]{machine.getId()});
        MachineInDatacenter machineInDatacenter = new MachineInDatacenter(machine, datacenterId);
        if (template.getOptions().getLoginPrivateKey() != null) {
            credentialsBuilder.privateKey(template.getOptions().getLoginPrivateKey());
        }
        return new ComputeServiceAdapter.NodeAndInitialCredentials((Object)machineInDatacenter, machineInDatacenter.slashEncode(), credentialsBuilder.build());
    }

    public Iterable<PackageInDatacenter> listHardwareProfiles() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (final String datacenterId : (Set)this.datacenterIds.get()) {
            builder.addAll(Iterables.transform(this.cloudApiApi.getPackageApiForDatacenter(datacenterId).list(), (Function)new Function<Package, PackageInDatacenter>(){

                public PackageInDatacenter apply(Package arg0) {
                    return new PackageInDatacenter(arg0, datacenterId);
                }
            }));
        }
        return builder.build();
    }

    public Iterable<DatasetInDatacenter> listImages() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (final String datacenterId : (Set)this.datacenterIds.get()) {
            builder.addAll(Iterables.transform(this.cloudApiApi.getDatasetApiForDatacenter(datacenterId).list(), (Function)new Function<Dataset, DatasetInDatacenter>(){

                public DatasetInDatacenter apply(Dataset arg0) {
                    return new DatasetInDatacenter(arg0, datacenterId);
                }
            }));
        }
        return builder.build();
    }

    public Iterable<MachineInDatacenter> listNodes() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (final String datacenterId : (Set)this.datacenterIds.get()) {
            builder.addAll(Iterables.transform(this.cloudApiApi.getMachineApiForDatacenter(datacenterId).list(), (Function)new Function<Machine, MachineInDatacenter>(){

                public MachineInDatacenter apply(Machine arg0) {
                    return new MachineInDatacenter(arg0, datacenterId);
                }
            }));
        }
        return builder.build();
    }

    public Iterable<MachineInDatacenter> listNodesByIds(final Iterable<String> ids) {
        return Iterables.filter(this.listNodes(), (Predicate)new Predicate<MachineInDatacenter>(){

            public boolean apply(MachineInDatacenter machine) {
                return Iterables.contains((Iterable)ids, (Object)machine.slashEncode());
            }
        });
    }

    public Iterable<Location> listLocations() {
        return ImmutableSet.of();
    }

    public MachineInDatacenter getNode(String id) {
        DatacenterAndId datacenterAndId = DatacenterAndId.fromSlashEncoded(id);
        Machine machine = this.cloudApiApi.getMachineApiForDatacenter(datacenterAndId.getDatacenter()).get(datacenterAndId.getId());
        return machine == null ? null : new MachineInDatacenter(machine, datacenterAndId.getDatacenter());
    }

    public DatasetInDatacenter getImage(String id) {
        DatacenterAndId datacenterAndId = DatacenterAndId.fromSlashEncoded(id);
        Dataset dataset = this.cloudApiApi.getDatasetApiForDatacenter(datacenterAndId.getDatacenter()).get(datacenterAndId.getId());
        return dataset == null ? null : new DatasetInDatacenter(dataset, datacenterAndId.getDatacenter());
    }

    public void destroyNode(String id) {
        final AtomicReference machine = Atomics.newReference((Object)this.getNode(id));
        if (machine.get() == null) {
            return;
        }
        if (((MachineInDatacenter)machine.get()).get().getState() == Machine.State.RUNNING) {
            this.logger.debug(">> stopping machine(%s) current state(%s)", new Object[]{((MachineInDatacenter)machine.get()).getId(), ((MachineInDatacenter)machine.get()).get().getState()});
            this.cloudApiApi.getMachineApiForDatacenter(((MachineInDatacenter)machine.get()).getDatacenter()).stop(((MachineInDatacenter)machine.get()).getId());
        }
        Preconditions.checkState((boolean)Predicates2.retry((Predicate)new Predicate<String>(){

            public boolean apply(String id) {
                machine.set(JoyentCloudComputeServiceAdapter.this.getNode(id));
                return machine == null || ((MachineInDatacenter)machine.get()).get().getState() != Machine.State.RUNNING;
            }
        }, (long)this.timeouts.nodeSuspended).apply((Object)id), (String)"<< unable to stop machine(%s) current state(%s)", (Object[])new Object[]{((MachineInDatacenter)machine.get()).getId(), ((MachineInDatacenter)machine.get()).get().getState()});
        this.logger.debug(">> deleting machine(%s) current state(%s)", new Object[]{((MachineInDatacenter)machine.get()).getId(), ((MachineInDatacenter)machine.get()).get().getState()});
        this.cloudApiApi.getMachineApiForDatacenter(((MachineInDatacenter)machine.get()).getDatacenter()).delete(((MachineInDatacenter)machine.get()).getId());
    }

    public void rebootNode(String id) {
        DatacenterAndId datacenterAndId = DatacenterAndId.fromSlashEncoded(id);
        this.cloudApiApi.getMachineApiForDatacenter(datacenterAndId.getDatacenter()).reboot(datacenterAndId.getId());
    }

    public void resumeNode(String id) {
        DatacenterAndId datacenterAndId = DatacenterAndId.fromSlashEncoded(id);
        this.cloudApiApi.getMachineApiForDatacenter(datacenterAndId.getDatacenter()).start(datacenterAndId.getId());
    }

    public void suspendNode(String id) {
        DatacenterAndId datacenterAndId = DatacenterAndId.fromSlashEncoded(id);
        this.cloudApiApi.getMachineApiForDatacenter(datacenterAndId.getDatacenter()).stop(datacenterAndId.getId());
    }
}

