/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.joyent.cloudapi.v6_5.compute.internal;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.jclouds.joyent.cloudapi.v6_5.domain.Key;

public class KeyAndPrivateKey {
    protected final Key key;
    protected final String privateKey;

    public static KeyAndPrivateKey fromKeyAndPrivateKey(Key key, String privateKey) {
        return new KeyAndPrivateKey(key, privateKey);
    }

    protected KeyAndPrivateKey(Key key, String privateKey) {
        this.key = (Key)Preconditions.checkNotNull((Object)key, (Object)"key");
        this.privateKey = (String)Preconditions.checkNotNull((Object)privateKey, (Object)"privateKey");
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.key, this.privateKey});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        KeyAndPrivateKey other = (KeyAndPrivateKey)obj;
        return Objects.equal((Object)this.key, (Object)other.key) && Objects.equal((Object)this.privateKey, (Object)other.privateKey);
    }

    public Key getKey() {
        return this.key;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    public String toString() {
        return "[key=" + this.key + ", privateKey=" + this.privateKey + "]";
    }
}

