/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.joyent.cloudapi.v6_5.compute.options;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import java.util.Map;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.scriptbuilder.domain.Statement;

public class JoyentCloudTemplateOptions
extends TemplateOptions
implements Cloneable {
    protected Optional<Boolean> generateKey = Optional.absent();

    public JoyentCloudTemplateOptions clone() {
        JoyentCloudTemplateOptions options = new JoyentCloudTemplateOptions();
        this.copyTo(options);
        return options;
    }

    public void copyTo(TemplateOptions to) {
        super.copyTo(to);
        if (to instanceof JoyentCloudTemplateOptions) {
            JoyentCloudTemplateOptions eTo = (JoyentCloudTemplateOptions)JoyentCloudTemplateOptions.class.cast(to);
            eTo.generateKey = this.generateKey;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JoyentCloudTemplateOptions that = (JoyentCloudTemplateOptions)JoyentCloudTemplateOptions.class.cast(o);
        return super.equals((Object)that) && Objects.equal(this.generateKey, that.generateKey);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.generateKey});
    }

    public Objects.ToStringHelper string() {
        return super.string().add("generateKey", this.generateKey.orNull());
    }

    public JoyentCloudTemplateOptions generateKey(boolean enable) {
        this.generateKey = Optional.of((Object)enable);
        return this;
    }

    public Optional<Boolean> shouldGenerateKey() {
        return this.generateKey;
    }

    public JoyentCloudTemplateOptions blockOnPort(int port, int seconds) {
        return (JoyentCloudTemplateOptions)JoyentCloudTemplateOptions.class.cast(super.blockOnPort(port, seconds));
    }

    public JoyentCloudTemplateOptions inboundPorts(int ... ports) {
        return (JoyentCloudTemplateOptions)JoyentCloudTemplateOptions.class.cast(super.inboundPorts(ports));
    }

    public JoyentCloudTemplateOptions authorizePublicKey(String publicKey) {
        return (JoyentCloudTemplateOptions)JoyentCloudTemplateOptions.class.cast(super.authorizePublicKey(publicKey));
    }

    public JoyentCloudTemplateOptions installPrivateKey(String privateKey) {
        return (JoyentCloudTemplateOptions)JoyentCloudTemplateOptions.class.cast(super.installPrivateKey(privateKey));
    }

    public JoyentCloudTemplateOptions blockUntilRunning(boolean blockUntilRunning) {
        return (JoyentCloudTemplateOptions)JoyentCloudTemplateOptions.class.cast(super.blockUntilRunning(blockUntilRunning));
    }

    public JoyentCloudTemplateOptions dontAuthorizePublicKey() {
        return (JoyentCloudTemplateOptions)JoyentCloudTemplateOptions.class.cast(super.dontAuthorizePublicKey());
    }

    public JoyentCloudTemplateOptions nameTask(String name) {
        return (JoyentCloudTemplateOptions)JoyentCloudTemplateOptions.class.cast(super.nameTask(name));
    }

    public JoyentCloudTemplateOptions runAsRoot(boolean runAsRoot) {
        return (JoyentCloudTemplateOptions)JoyentCloudTemplateOptions.class.cast(super.runAsRoot(runAsRoot));
    }

    public JoyentCloudTemplateOptions runScript(Statement script) {
        return (JoyentCloudTemplateOptions)JoyentCloudTemplateOptions.class.cast(super.runScript(script));
    }

    public JoyentCloudTemplateOptions overrideLoginCredentials(LoginCredentials overridingCredentials) {
        return (JoyentCloudTemplateOptions)JoyentCloudTemplateOptions.class.cast(super.overrideLoginCredentials(overridingCredentials));
    }

    public JoyentCloudTemplateOptions overrideLoginPassword(String password) {
        return (JoyentCloudTemplateOptions)JoyentCloudTemplateOptions.class.cast(super.overrideLoginPassword(password));
    }

    public JoyentCloudTemplateOptions overrideLoginPrivateKey(String privateKey) {
        return (JoyentCloudTemplateOptions)JoyentCloudTemplateOptions.class.cast(super.overrideLoginPrivateKey(privateKey));
    }

    public JoyentCloudTemplateOptions overrideLoginUser(String loginUser) {
        return (JoyentCloudTemplateOptions)JoyentCloudTemplateOptions.class.cast(super.overrideLoginUser(loginUser));
    }

    public JoyentCloudTemplateOptions overrideAuthenticateSudo(boolean authenticateSudo) {
        return (JoyentCloudTemplateOptions)JoyentCloudTemplateOptions.class.cast(super.overrideAuthenticateSudo(authenticateSudo));
    }

    public JoyentCloudTemplateOptions userMetadata(Map<String, String> userMetadata) {
        return (JoyentCloudTemplateOptions)JoyentCloudTemplateOptions.class.cast(super.userMetadata(userMetadata));
    }

    public JoyentCloudTemplateOptions userMetadata(String key, String value) {
        return (JoyentCloudTemplateOptions)JoyentCloudTemplateOptions.class.cast(super.userMetadata(key, value));
    }

    public static class Builder {
        public static JoyentCloudTemplateOptions generateKey(boolean enable) {
            return new JoyentCloudTemplateOptions().generateKey(enable);
        }

        public static JoyentCloudTemplateOptions inboundPorts(int ... ports) {
            JoyentCloudTemplateOptions options = new JoyentCloudTemplateOptions();
            return (JoyentCloudTemplateOptions)JoyentCloudTemplateOptions.class.cast(options.inboundPorts(ports));
        }

        public static JoyentCloudTemplateOptions blockOnPort(int port, int seconds) {
            JoyentCloudTemplateOptions options = new JoyentCloudTemplateOptions();
            return (JoyentCloudTemplateOptions)JoyentCloudTemplateOptions.class.cast(options.blockOnPort(port, seconds));
        }

        public static JoyentCloudTemplateOptions installPrivateKey(String rsaKey) {
            JoyentCloudTemplateOptions options = new JoyentCloudTemplateOptions();
            return (JoyentCloudTemplateOptions)JoyentCloudTemplateOptions.class.cast(options.installPrivateKey(rsaKey));
        }

        public static JoyentCloudTemplateOptions authorizePublicKey(String rsaKey) {
            JoyentCloudTemplateOptions options = new JoyentCloudTemplateOptions();
            return (JoyentCloudTemplateOptions)JoyentCloudTemplateOptions.class.cast(options.authorizePublicKey(rsaKey));
        }

        public static JoyentCloudTemplateOptions userMetadata(Map<String, String> userMetadata) {
            JoyentCloudTemplateOptions options = new JoyentCloudTemplateOptions();
            return (JoyentCloudTemplateOptions)JoyentCloudTemplateOptions.class.cast(options.userMetadata((Map)userMetadata));
        }

        public static JoyentCloudTemplateOptions overrideLoginUser(String user) {
            JoyentCloudTemplateOptions options = new JoyentCloudTemplateOptions();
            return options.overrideLoginUser(user);
        }

        public static JoyentCloudTemplateOptions overrideLoginPassword(String password) {
            JoyentCloudTemplateOptions options = new JoyentCloudTemplateOptions();
            return options.overrideLoginPassword(password);
        }

        public static JoyentCloudTemplateOptions overrideLoginPrivateKey(String privateKey) {
            JoyentCloudTemplateOptions options = new JoyentCloudTemplateOptions();
            return options.overrideLoginPrivateKey(privateKey);
        }

        public static JoyentCloudTemplateOptions overrideAuthenticateSudo(boolean authenticateSudo) {
            JoyentCloudTemplateOptions options = new JoyentCloudTemplateOptions();
            return options.overrideAuthenticateSudo(authenticateSudo);
        }

        public static JoyentCloudTemplateOptions overrideLoginCredentials(LoginCredentials credentials) {
            JoyentCloudTemplateOptions options = new JoyentCloudTemplateOptions();
            return options.overrideLoginCredentials(credentials);
        }

        public static JoyentCloudTemplateOptions blockUntilRunning(boolean blockUntilRunning) {
            JoyentCloudTemplateOptions options = new JoyentCloudTemplateOptions();
            return options.blockUntilRunning(blockUntilRunning);
        }
    }
}

