/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.joyent.cloudapi.v6_5.domain.datacenterscoped;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;

public class DatacenterAndId {
    protected final String datacenterId;
    protected final String id;

    public static DatacenterAndId fromSlashEncoded(String id) {
        Iterable parts = Splitter.on((char)'/').split((CharSequence)Preconditions.checkNotNull((Object)id, (Object)"id"));
        Preconditions.checkArgument((Iterables.size((Iterable)parts) == 2 ? 1 : 0) != 0, (Object)"id must be in format datacenterId/id");
        return new DatacenterAndId((String)Iterables.get((Iterable)parts, (int)0), (String)Iterables.get((Iterable)parts, (int)1));
    }

    public static DatacenterAndId fromDatacenterAndId(String datacenterId, String id) {
        return new DatacenterAndId(datacenterId, id);
    }

    private static String slashEncodeDatacenterAndId(String datacenterId, String id) {
        return (String)Preconditions.checkNotNull((Object)datacenterId, (Object)"datacenterId") + "/" + (String)Preconditions.checkNotNull((Object)id, (Object)"id");
    }

    public String slashEncode() {
        return DatacenterAndId.slashEncodeDatacenterAndId(this.datacenterId, this.id);
    }

    protected DatacenterAndId(String datacenterId, String id) {
        this.datacenterId = (String)Preconditions.checkNotNull((Object)datacenterId, (Object)"datacenterId");
        this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id");
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.datacenterId, this.id});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DatacenterAndId other = (DatacenterAndId)obj;
        return Objects.equal((Object)this.datacenterId, (Object)other.datacenterId) && Objects.equal((Object)this.id, (Object)other.id);
    }

    public String getDatacenter() {
        return this.datacenterId;
    }

    public String getId() {
        return this.id;
    }

    public String toString() {
        return "[datacenterId=" + this.datacenterId + ", id=" + this.id + "]";
    }
}

