/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.joyent.cloudapi.v6_5.options;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.Map;
import org.jclouds.http.options.BaseHttpRequestOptions;
import org.jclouds.util.Maps2;

public class CreateMachineOptions
extends BaseHttpRequestOptions {
    private String name;
    private String pkg;
    private Map<String, String> metadata = ImmutableMap.of();

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof CreateMachineOptions) {
            CreateMachineOptions other = (CreateMachineOptions)((Object)CreateMachineOptions.class.cast(object));
            return Objects.equal((Object)this.name, (Object)other.name) && Objects.equal((Object)this.pkg, (Object)other.pkg) && Objects.equal(this.metadata, other.metadata);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.pkg, this.metadata});
    }

    public String toString() {
        Objects.ToStringHelper toString = Objects.toStringHelper((String)"").omitNullValues();
        toString.add("name", (Object)this.name).add("package", (Object)this.name);
        if (this.metadata.size() > 0) {
            toString.add("metadata", this.metadata);
        }
        return toString.toString();
    }

    public Multimap<String, String> buildQueryParameters() {
        Multimap params = super.buildQueryParameters();
        if (this.name != null) {
            params.put((Object)"name", (Object)this.name);
        }
        if (this.pkg != null) {
            params.put((Object)"package", (Object)this.pkg);
        }
        params.putAll((Multimap)Multimaps.forMap((Map)Maps2.transformKeys(this.metadata, (Function)new Function<String, String>(){

            public String apply(String input) {
                return "metadata." + input;
            }
        })));
        return params;
    }

    public CreateMachineOptions name(String name) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
        return this;
    }

    public CreateMachineOptions packageName(String packageName) {
        this.pkg = (String)Preconditions.checkNotNull((Object)packageName, (Object)"packageName");
        return this;
    }

    public CreateMachineOptions metadata(Map<String, String> metadata) {
        Preconditions.checkNotNull(metadata, (Object)"metadata");
        this.metadata = ImmutableMap.copyOf(metadata);
        return this;
    }

    public static class Builder {
        public static CreateMachineOptions name(String name) {
            CreateMachineOptions options = new CreateMachineOptions();
            return options.name(name);
        }

        public static CreateMachineOptions packageName(String packageName) {
            CreateMachineOptions options = new CreateMachineOptions();
            return options.packageName(packageName);
        }

        public static CreateMachineOptions metadata(Map<String, String> metadata) {
            CreateMachineOptions options = new CreateMachineOptions();
            return options.metadata(metadata);
        }
    }
}

