/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.gogrid.domain.internal;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import java.beans.ConstructorProperties;

public class ErrorResponse
implements Comparable<ErrorResponse> {
    private final String message;
    private final String errorCode;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromErrorResponse(this);
    }

    @ConstructorProperties(value={"message", "errorcode"})
    protected ErrorResponse(String message, String errorCode) {
        this.message = (String)Preconditions.checkNotNull((Object)message, (Object)"message");
        this.errorCode = (String)Preconditions.checkNotNull((Object)errorCode, (Object)"errorCode");
    }

    public String getMessage() {
        return this.message;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.message, this.errorCode});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ErrorResponse that = (ErrorResponse)ErrorResponse.class.cast(obj);
        return Objects.equal((Object)this.message, (Object)that.message) && Objects.equal((Object)this.errorCode, (Object)that.errorCode);
    }

    @Override
    public int compareTo(ErrorResponse that) {
        return ComparisonChain.start().compare((Comparable)((Object)this.errorCode), (Comparable)((Object)that.errorCode)).compare((Comparable)((Object)this.message), (Comparable)((Object)that.message)).result();
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((Object)this).add("message", (Object)this.message).add("errorCode", (Object)this.errorCode);
    }

    public String toString() {
        return this.string().toString();
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String message;
        protected String errorCode;

        protected abstract T self();

        public T message(String message) {
            this.message = message;
            return this.self();
        }

        public T errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this.self();
        }

        public ErrorResponse build() {
            return new ErrorResponse(this.message, this.errorCode);
        }

        public T fromErrorResponse(ErrorResponse in) {
            return ((Builder)this.message(in.getMessage())).errorCode(in.getErrorCode());
        }
    }
}

