/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.config;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.TypeAdapterFactory;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Set;
import javax.inject.Singleton;
import org.jclouds.googlecloud.config.ListPageAdapterFactory;
import org.jclouds.googlecomputeengine.domain.Firewall;
import org.jclouds.googlecomputeengine.options.FirewallOptions;
import org.jclouds.googlecomputeengine.options.RouteOptions;
import org.jclouds.json.config.GsonModule;

public final class GoogleComputeEngineParserModule
extends AbstractModule {
    protected void configure() {
        this.bind(GsonModule.DateAdapter.class).to(GsonModule.Iso8601DateAdapter.class);
    }

    @Provides
    @Singleton
    Map<Type, Object> typeAdapters() {
        return new ImmutableMap.Builder().put(FirewallOptions.class, (Object)new FirewallOptionsTypeAdapter()).put(RouteOptions.class, (Object)new RouteOptionsTypeAdapter()).build();
    }

    @Provides
    @Singleton
    Set<TypeAdapterFactory> typeAdapterFactories() {
        return ImmutableSet.of((Object)new ListPageAdapterFactory());
    }

    private static JsonArray buildArrayOfStrings(Iterable<String> strings) {
        JsonArray array = new JsonArray();
        for (String string : strings) {
            array.add((JsonElement)new JsonPrimitive(string));
        }
        return array;
    }

    private static final class RouteOptionsTypeAdapter
    implements JsonSerializer<RouteOptions> {
        private RouteOptionsTypeAdapter() {
        }

        public JsonElement serialize(RouteOptions src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject route = new JsonObject();
            if (src.name() != null) {
                route.addProperty("name", src.name());
            }
            if (src.getNetwork() != null) {
                route.addProperty("network", src.getNetwork().toString());
            }
            if (src.getNextHopGateway() != null) {
                route.addProperty("nextHopGateway", src.getNextHopGateway().toString());
            }
            if (src.getNextHopInstance() != null) {
                route.addProperty("nextHopInstance", src.getNextHopInstance().toString());
            }
            if (src.getNextHopNetwork() != null) {
                route.addProperty("nextHopNetwork", src.getNextHopNetwork().toString());
            }
            if (src.getDestRange() != null) {
                route.addProperty("destRange", src.getDestRange());
            }
            if (src.getDescription() != null) {
                route.addProperty("description", src.getDescription());
            }
            if (src.getPriority() != null) {
                route.addProperty("priority", (Number)src.getPriority());
            }
            if (src.getNextHopIp() != null) {
                route.addProperty("nextHopIp", src.getNextHopIp());
            }
            if (!src.getTags().isEmpty()) {
                route.add("tags", (JsonElement)GoogleComputeEngineParserModule.buildArrayOfStrings(src.getTags()));
            }
            return route;
        }
    }

    private static final class FirewallOptionsTypeAdapter
    implements JsonSerializer<FirewallOptions> {
        private FirewallOptionsTypeAdapter() {
        }

        public JsonElement serialize(FirewallOptions src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject firewall = new JsonObject();
            if (src.name() != null) {
                firewall.addProperty("name", src.name());
            }
            if (src.network() != null) {
                firewall.addProperty("network", src.network().toString());
            }
            if (!src.sourceRanges().isEmpty()) {
                firewall.add("sourceRanges", (JsonElement)GoogleComputeEngineParserModule.buildArrayOfStrings(src.sourceRanges()));
            }
            if (!src.sourceTags().isEmpty()) {
                firewall.add("sourceTags", (JsonElement)GoogleComputeEngineParserModule.buildArrayOfStrings(src.sourceTags()));
            }
            if (!src.targetTags().isEmpty()) {
                firewall.add("targetTags", (JsonElement)GoogleComputeEngineParserModule.buildArrayOfStrings(src.targetTags()));
            }
            if (!src.getAllowed().isEmpty()) {
                JsonArray rules = new JsonArray();
                for (Firewall.Rule rule : src.getAllowed()) {
                    rules.add(context.serialize((Object)rule, Firewall.Rule.class));
                }
                firewall.add("allowed", (JsonElement)rules);
            }
            return firewall;
        }
    }
}

