/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.MavenArtifactFilterManager;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataRetrievalException;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.metadata.ResolutionGroup;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.MultipleArtifactsNotFoundException;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.execution.RuntimeInformation;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.monitor.event.EventDispatcher;
import org.apache.maven.monitor.logging.DefaultLog;
import org.apache.maven.plugin.ContextEnabled;
import org.apache.maven.plugin.DebugConfigurationListener;
import org.apache.maven.plugin.InvalidPluginException;
import org.apache.maven.plugin.MavenPluginCollector;
import org.apache.maven.plugin.Mojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.PluginConfigurationException;
import org.apache.maven.plugin.PluginManager;
import org.apache.maven.plugin.PluginManagerException;
import org.apache.maven.plugin.PluginMappingManager;
import org.apache.maven.plugin.PluginNotFoundException;
import org.apache.maven.plugin.PluginParameterException;
import org.apache.maven.plugin.PluginParameterExpressionEvaluator;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.Parameter;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugin.descriptor.PluginDescriptorBuilder;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.version.PluginVersionManager;
import org.apache.maven.plugin.version.PluginVersionNotFoundException;
import org.apache.maven.plugin.version.PluginVersionResolutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.artifact.InvalidDependencyVersionException;
import org.apache.maven.project.artifact.MavenMetadataSource;
import org.apache.maven.project.path.PathTranslator;
import org.apache.maven.reporting.MavenReport;
import org.apache.maven.settings.Settings;
import org.codehaus.classworlds.ClassRealm;
import org.codehaus.classworlds.NoSuchRealmException;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.PlexusContainerException;
import org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.codehaus.plexus.component.configurator.ComponentConfigurator;
import org.codehaus.plexus.component.configurator.ConfigurationListener;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.component.repository.exception.ComponentLifecycleException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.xml.XmlPlexusConfiguration;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class DefaultPluginManager
extends AbstractLogEnabled
implements PluginManager,
Initializable,
Contextualizable {
    protected PlexusContainer container;
    protected PluginDescriptorBuilder pluginDescriptorBuilder;
    protected ArtifactFilter artifactFilter;
    private Log mojoLogger;
    private Map resolvedCoreArtifactFiles = new HashMap();
    protected PathTranslator pathTranslator;
    protected MavenPluginCollector pluginCollector;
    protected PluginVersionManager pluginVersionManager;
    protected ArtifactFactory artifactFactory;
    protected ArtifactResolver artifactResolver;
    protected ArtifactMetadataSource artifactMetadataSource;
    protected RuntimeInformation runtimeInformation;
    protected MavenProjectBuilder mavenProjectBuilder;
    protected PluginMappingManager pluginMappingManager;

    public DefaultPluginManager() {
        this.pluginDescriptorBuilder = new PluginDescriptorBuilder();
    }

    public PluginDescriptor getPluginDescriptorForPrefix(String prefix) {
        return this.pluginCollector.getPluginDescriptorForPrefix(prefix);
    }

    public Plugin getPluginDefinitionForPrefix(String prefix, MavenSession session, MavenProject project) {
        return this.pluginMappingManager.getByPrefix(prefix, session.getSettings().getPluginGroups(), project.getPluginArtifactRepositories(), session.getLocalRepository());
    }

    public PluginDescriptor verifyPlugin(Plugin plugin, MavenProject project, Settings settings, ArtifactRepository localRepository) throws ArtifactResolutionException, PluginVersionResolutionException, ArtifactNotFoundException, InvalidVersionSpecificationException, InvalidPluginException, PluginManagerException, PluginNotFoundException, PluginVersionNotFoundException {
        if (plugin.getVersion() == null) {
            String version = this.pluginVersionManager.resolvePluginVersion(plugin.getGroupId(), plugin.getArtifactId(), project, settings, localRepository);
            plugin.setVersion(version);
        }
        return this.verifyVersionedPlugin(plugin, project, localRepository);
    }

    private PluginDescriptor verifyVersionedPlugin(Plugin plugin, MavenProject project, ArtifactRepository localRepository) throws PluginVersionResolutionException, ArtifactNotFoundException, ArtifactResolutionException, InvalidVersionSpecificationException, InvalidPluginException, PluginManagerException, PluginNotFoundException {
        try {
            VersionRange versionRange = VersionRange.createFromVersionSpec((String)plugin.getVersion());
            ArrayList remoteRepositories = new ArrayList();
            remoteRepositories.addAll(project.getPluginArtifactRepositories());
            remoteRepositories.addAll(project.getRemoteArtifactRepositories());
            this.checkRequiredMavenVersion(plugin, localRepository, remoteRepositories);
            Artifact pluginArtifact = this.artifactFactory.createPluginArtifact(plugin.getGroupId(), plugin.getArtifactId(), versionRange);
            pluginArtifact = project.replaceWithActiveArtifact(pluginArtifact);
            this.artifactResolver.resolve(pluginArtifact, project.getPluginArtifactRepositories(), localRepository);
            PlexusContainer pluginContainer = this.container.getChildContainer(plugin.getKey());
            File pluginFile = pluginArtifact.getFile();
            if (!this.pluginCollector.isPluginInstalled(plugin) || pluginContainer == null) {
                this.addPlugin(plugin, pluginArtifact, project, localRepository);
            } else if (pluginFile.lastModified() > pluginContainer.getCreationDate().getTime()) {
                this.getLogger().info("Reloading plugin container for: " + plugin.getKey() + ". The plugin artifact has changed.");
                pluginContainer.dispose();
                this.pluginCollector.flushPluginDescriptor(plugin);
                this.addPlugin(plugin, pluginArtifact, project, localRepository);
            }
            project.addPlugin(plugin);
        }
        catch (ArtifactNotFoundException e) {
            String groupId = plugin.getGroupId();
            String artifactId = plugin.getArtifactId();
            String version = plugin.getVersion();
            if (groupId == null || artifactId == null || version == null) {
                throw new PluginNotFoundException(e);
            }
            if (groupId.equals(e.getGroupId()) && artifactId.equals(e.getArtifactId()) && version.equals(e.getVersion()) && "maven-plugin".equals(e.getType())) {
                throw new PluginNotFoundException(e);
            }
            throw e;
        }
        return this.pluginCollector.getPluginDescriptor(plugin);
    }

    private void checkRequiredMavenVersion(Plugin plugin, ArtifactRepository localRepository, List remoteRepositories) throws PluginVersionResolutionException, InvalidPluginException {
        try {
            Artifact artifact = this.artifactFactory.createProjectArtifact(plugin.getGroupId(), plugin.getArtifactId(), plugin.getVersion());
            MavenProject project = this.mavenProjectBuilder.buildFromRepository(artifact, remoteRepositories, localRepository, false);
            if (project.getPrerequisites() != null && project.getPrerequisites().getMaven() != null) {
                DefaultArtifactVersion requiredVersion = new DefaultArtifactVersion(project.getPrerequisites().getMaven());
                if (this.runtimeInformation.getApplicationVersion().compareTo((Object)requiredVersion) < 0) {
                    throw new PluginVersionResolutionException(plugin.getGroupId(), plugin.getArtifactId(), "Plugin requires Maven version " + requiredVersion);
                }
            }
        }
        catch (ProjectBuildingException e) {
            throw new InvalidPluginException("Unable to build project for plugin '" + plugin.getKey() + "': " + e.getMessage(), (Exception)((Object)e));
        }
    }

    protected void addPlugin(Plugin plugin, Artifact pluginArtifact, MavenProject project, ArtifactRepository localRepository) throws PluginManagerException, InvalidPluginException {
        PlexusContainer child;
        try {
            child = this.container.createChildContainer(plugin.getKey(), Collections.singletonList(pluginArtifact.getFile()), Collections.EMPTY_MAP, Collections.singletonList(this.pluginCollector));
            try {
                child.getContainerRealm().importFrom("plexus.core", "org.codehaus.plexus.util.xml.Xpp3Dom");
                child.getContainerRealm().importFrom("plexus.core", "org.codehaus.plexus.util.xml.pull");
                child.getContainerRealm().importFrom("plexus.core", "/default-report.xml");
            }
            catch (NoSuchRealmException e) {}
        }
        catch (PlexusContainerException e) {
            throw new PluginManagerException("Failed to create plugin container for plugin '" + plugin + "': " + e.getMessage(), (Exception)((Object)e));
        }
        PluginDescriptor addedPlugin = this.pluginCollector.getPluginDescriptor(plugin);
        if (addedPlugin == null) {
            throw new IllegalStateException("The PluginDescriptor for the plugin " + plugin + " was not found.");
        }
        addedPlugin.setClassRealm(child.getContainerRealm());
        addedPlugin.setArtifacts(Collections.singletonList(pluginArtifact));
        try {
            Plugin projectPlugin = (Plugin)project.getBuild().getPluginsAsMap().get(plugin.getKey());
            if (projectPlugin == null) {
                projectPlugin = plugin;
            }
            Set artifacts = MavenMetadataSource.createArtifacts((ArtifactFactory)this.artifactFactory, (List)projectPlugin.getDependencies(), null, null, (MavenProject)project);
            addedPlugin.setIntroducedDependencyArtifacts(artifacts);
        }
        catch (InvalidDependencyVersionException e) {
            throw new InvalidPluginException("Plugin '" + plugin + "' is invalid: " + e.getMessage(), (Exception)((Object)e));
        }
    }

    public void executeMojo(MavenProject project, MojoExecution mojoExecution, MavenSession session) throws ArtifactResolutionException, MojoExecutionException, MojoFailureException, ArtifactNotFoundException, InvalidDependencyVersionException, PluginManagerException, PluginConfigurationException {
        MojoDescriptor mojoDescriptor = mojoExecution.getMojoDescriptor();
        if (mojoDescriptor.isProjectRequired() && !session.isUsingPOMsFromFilesystem()) {
            throw new MojoExecutionException("Cannot execute mojo: " + mojoDescriptor.getGoal() + ". It requires a project with an existing pom.xml, but the build is not using one.");
        }
        if (mojoDescriptor.isOnlineRequired() && session.getSettings().isOffline()) {
            throw new MojoExecutionException("Mojo: " + mojoDescriptor.getGoal() + " requires online mode for execution. Maven is currently offline.");
        }
        if (mojoDescriptor.isDependencyResolutionRequired() != null) {
            Collection<Object> projects = mojoDescriptor.isAggregator() ? session.getSortedProjects() : Collections.singleton(project);
            Iterator<Object> i = projects.iterator();
            while (i.hasNext()) {
                MavenProject p = (MavenProject)i.next();
                this.resolveTransitiveDependencies(session, this.artifactResolver, mojoDescriptor.isDependencyResolutionRequired(), this.artifactFactory, p, mojoDescriptor.isAggregator());
            }
            this.downloadDependencies(project, session, this.artifactResolver);
        }
        String goalName = mojoDescriptor.getFullGoalName();
        PluginDescriptor pluginDescriptor = mojoDescriptor.getPluginDescriptor();
        String goalId = mojoDescriptor.getGoal();
        String groupId = pluginDescriptor.getGroupId();
        String artifactId = pluginDescriptor.getArtifactId();
        String executionId = mojoExecution.getExecutionId();
        Xpp3Dom dom = project.getGoalConfiguration(groupId, artifactId, executionId, goalId);
        Xpp3Dom reportDom = project.getReportConfiguration(groupId, artifactId, executionId);
        dom = Xpp3Dom.mergeXpp3Dom((Xpp3Dom)dom, (Xpp3Dom)reportDom);
        if (mojoExecution.getConfiguration() != null) {
            dom = Xpp3Dom.mergeXpp3Dom((Xpp3Dom)dom, (Xpp3Dom)mojoExecution.getConfiguration());
        }
        Mojo plugin = this.getConfiguredMojo(session, dom, project, false, mojoExecution);
        String event = "mojo-execute";
        EventDispatcher dispatcher = session.getEventDispatcher();
        String goalExecId = goalName;
        if (mojoExecution.getExecutionId() != null) {
            goalExecId = goalExecId + " {execution: " + mojoExecution.getExecutionId() + "}";
        }
        dispatcher.dispatchStart(event, goalExecId);
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(mojoDescriptor.getPluginDescriptor().getClassRealm().getClassLoader());
            plugin.execute();
            dispatcher.dispatchEnd(event, goalExecId);
        }
        catch (MojoExecutionException e) {
            session.getEventDispatcher().dispatchError(event, goalExecId, (Throwable)e);
            throw e;
        }
        catch (MojoFailureException e) {
            session.getEventDispatcher().dispatchError(event, goalExecId, (Throwable)e);
            throw e;
        }
        catch (LinkageError e) {
            if (this.getLogger().isFatalErrorEnabled()) {
                this.getLogger().fatalError(plugin.getClass().getName() + "#execute() caused a linkage error (" + e.getClass().getName() + ") and may be out-of-date. Check the realms:");
                ClassRealm pluginRealm = mojoDescriptor.getPluginDescriptor().getClassRealm();
                StringBuffer sb = new StringBuffer();
                sb.append("Plugin realm = " + pluginRealm.getId()).append('\n');
                for (int i = 0; i < pluginRealm.getConstituents().length; ++i) {
                    sb.append("urls[" + i + "] = " + pluginRealm.getConstituents()[i]);
                    if (i == pluginRealm.getConstituents().length - 1) continue;
                    sb.append('\n');
                }
                this.getLogger().fatalError(sb.toString());
                ClassRealm containerRealm = this.container.getContainerRealm();
                sb = new StringBuffer();
                sb.append("Container realm = " + containerRealm.getId()).append('\n');
                for (int i = 0; i < containerRealm.getConstituents().length; ++i) {
                    sb.append("urls[" + i + "] = " + containerRealm.getConstituents()[i]);
                    if (i == containerRealm.getConstituents().length - 1) continue;
                    sb.append('\n');
                }
                this.getLogger().fatalError(sb.toString());
            }
            session.getEventDispatcher().dispatchError(event, goalExecId, (Throwable)e);
            throw e;
        }
        finally {
            block21: {
                Thread.currentThread().setContextClassLoader(oldClassLoader);
                try {
                    PlexusContainer pluginContainer = this.getPluginContainer(mojoDescriptor.getPluginDescriptor());
                    pluginContainer.release((Object)plugin);
                }
                catch (ComponentLifecycleException e) {
                    if (!this.getLogger().isErrorEnabled()) break block21;
                    this.getLogger().error("Error releasing plugin - ignoring.", (Throwable)e);
                }
            }
        }
    }

    public MavenReport getReport(MavenProject project, MojoExecution mojoExecution, MavenSession session) throws ArtifactNotFoundException, PluginConfigurationException, PluginManagerException, ArtifactResolutionException {
        MojoDescriptor mojoDescriptor = mojoExecution.getMojoDescriptor();
        PluginDescriptor descriptor = mojoDescriptor.getPluginDescriptor();
        Xpp3Dom dom = project.getReportConfiguration(descriptor.getGroupId(), descriptor.getArtifactId(), mojoExecution.getExecutionId());
        if (mojoExecution.getConfiguration() != null) {
            dom = Xpp3Dom.mergeXpp3Dom((Xpp3Dom)dom, (Xpp3Dom)mojoExecution.getConfiguration());
        }
        return (MavenReport)this.getConfiguredMojo(session, dom, project, true, mojoExecution);
    }

    public PluginDescriptor verifyReportPlugin(ReportPlugin reportPlugin, MavenProject project, MavenSession session) throws PluginVersionResolutionException, ArtifactResolutionException, ArtifactNotFoundException, InvalidVersionSpecificationException, InvalidPluginException, PluginManagerException, PluginNotFoundException, PluginVersionNotFoundException {
        String version = reportPlugin.getVersion();
        if (version == null) {
            version = this.pluginVersionManager.resolveReportPluginVersion(reportPlugin.getGroupId(), reportPlugin.getArtifactId(), project, session.getSettings(), session.getLocalRepository());
            reportPlugin.setVersion(version);
        }
        Plugin forLookup = new Plugin();
        forLookup.setGroupId(reportPlugin.getGroupId());
        forLookup.setArtifactId(reportPlugin.getArtifactId());
        forLookup.setVersion(version);
        return this.verifyVersionedPlugin(forLookup, project, session.getLocalRepository());
    }

    private PlexusContainer getPluginContainer(PluginDescriptor pluginDescriptor) throws PluginManagerException {
        String pluginKey = pluginDescriptor.getPluginLookupKey();
        PlexusContainer pluginContainer = this.container.getChildContainer(pluginKey);
        if (pluginContainer == null) {
            throw new PluginManagerException("Cannot find Plexus container for plugin: " + pluginKey);
        }
        return pluginContainer;
    }

    private Mojo getConfiguredMojo(MavenSession session, Xpp3Dom dom, MavenProject project, boolean report, MojoExecution mojoExecution) throws PluginConfigurationException, ArtifactNotFoundException, PluginManagerException, ArtifactResolutionException {
        Mojo plugin;
        MojoDescriptor mojoDescriptor = mojoExecution.getMojoDescriptor();
        PluginDescriptor pluginDescriptor = mojoDescriptor.getPluginDescriptor();
        PlexusContainer pluginContainer = this.getPluginContainer(pluginDescriptor);
        this.ensurePluginContainerIsComplete(pluginDescriptor, pluginContainer, project, session);
        try {
            plugin = (Mojo)pluginContainer.lookup(Mojo.ROLE, mojoDescriptor.getRoleHint());
            if (report && !(plugin instanceof MavenReport)) {
                return null;
            }
        }
        catch (ComponentLookupException e) {
            throw new PluginManagerException("Unable to find the mojo '" + mojoDescriptor.getRoleHint() + "' in the plugin '" + pluginDescriptor.getPluginLookupKey() + "'", (Exception)((Object)e));
        }
        if (plugin instanceof ContextEnabled) {
            Map pluginContext = session.getPluginContext(pluginDescriptor, project);
            ((ContextEnabled)plugin).setPluginContext(pluginContext);
        }
        plugin.setLog(this.mojoLogger);
        XmlPlexusConfiguration pomConfiguration = dom == null ? new XmlPlexusConfiguration("configuration") : new XmlPlexusConfiguration(dom);
        this.validatePomConfiguration(mojoDescriptor, (PlexusConfiguration)pomConfiguration);
        PlexusConfiguration mergedConfiguration = this.mergeMojoConfiguration(pomConfiguration, mojoDescriptor);
        PluginParameterExpressionEvaluator expressionEvaluator = new PluginParameterExpressionEvaluator(session, mojoExecution, this.pathTranslator, this.getLogger(), project, session.getExecutionProperties());
        PlexusConfiguration extractedMojoConfiguration = this.extractMojoConfiguration(mergedConfiguration, mojoDescriptor);
        this.checkRequiredParameters(mojoDescriptor, extractedMojoConfiguration, expressionEvaluator);
        this.populatePluginFields(plugin, mojoDescriptor, extractedMojoConfiguration, pluginContainer, expressionEvaluator);
        return plugin;
    }

    private void ensurePluginContainerIsComplete(PluginDescriptor pluginDescriptor, PlexusContainer pluginContainer, MavenProject project, MavenSession session) throws ArtifactNotFoundException, PluginManagerException, ArtifactResolutionException {
        if (pluginDescriptor.getArtifacts() != null && pluginDescriptor.getArtifacts().size() == 1) {
            ResolutionGroup resolutionGroup;
            Artifact pluginArtifact = (Artifact)pluginDescriptor.getArtifacts().get(0);
            ArtifactRepository localRepository = session.getLocalRepository();
            try {
                resolutionGroup = this.artifactMetadataSource.retrieve(pluginArtifact, localRepository, project.getPluginArtifactRepositories());
            }
            catch (ArtifactMetadataRetrievalException e) {
                throw new ArtifactResolutionException("Unable to download metadata from repository for plugin '" + pluginArtifact.getId() + "': " + e.getMessage(), pluginArtifact, (Throwable)e);
            }
            DefaultPluginManager.checkPlexusUtils(resolutionGroup, this.artifactFactory);
            LinkedHashMap<String, Artifact> dependencyMap = new LinkedHashMap<String, Artifact>();
            ArrayList all = new ArrayList();
            all.addAll(pluginDescriptor.getIntroducedDependencyArtifacts());
            all.addAll(resolutionGroup.getArtifacts());
            Iterator it = all.iterator();
            while (it.hasNext()) {
                Artifact artifact = (Artifact)it.next();
                String conflictId = artifact.getDependencyConflictId();
                if (dependencyMap.containsKey(conflictId)) continue;
                dependencyMap.put(conflictId, artifact);
            }
            LinkedHashSet dependencies = new LinkedHashSet(dependencyMap.values());
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Plugin dependencies for:\n\n" + pluginDescriptor.getId() + "\n\nare:\n\n" + StringUtils.join(dependencies.iterator(), (String)"\n") + "\n\n");
            }
            ArrayList repositories = new ArrayList();
            repositories.addAll(resolutionGroup.getResolutionRepositories());
            repositories.addAll(project.getRemoteArtifactRepositories());
            Map pluginManagedDependencies = new HashMap();
            try {
                MavenProject pluginProject = this.mavenProjectBuilder.buildFromRepository(pluginArtifact, project.getRemoteArtifactRepositories(), localRepository);
                if (pluginProject != null) {
                    pluginManagedDependencies = pluginProject.getManagedVersionMap();
                }
            }
            catch (ProjectBuildingException e) {
                // empty catch block
            }
            ArtifactResolutionResult result = this.artifactResolver.resolveTransitively(dependencies, pluginArtifact, pluginManagedDependencies, localRepository, repositories, this.artifactMetadataSource, this.artifactFilter);
            Set resolved = result.getArtifacts();
            Iterator it2 = resolved.iterator();
            while (it2.hasNext()) {
                Artifact artifact = (Artifact)it2.next();
                if (artifact.equals(pluginArtifact)) continue;
                artifact = project.replaceWithActiveArtifact(artifact);
                try {
                    pluginContainer.addJarResource(artifact.getFile());
                }
                catch (PlexusContainerException e) {
                    throw new PluginManagerException("Error adding plugin dependency '" + artifact.getDependencyConflictId() + "' into plugin manager: " + e.getMessage(), (Exception)((Object)e));
                }
            }
            pluginDescriptor.setClassRealm(pluginContainer.getContainerRealm());
            ArrayList unresolved = new ArrayList(dependencies);
            unresolved.removeAll(resolved);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug(" The following artifacts were filtered out for plugin: " + pluginDescriptor.getId() + " because they're already in the core of Maven:\n\n" + StringUtils.join(unresolved.iterator(), (String)"\n") + "\n\nThese will use the artifact files already in the core ClassRealm instead, to allow them to be included in PluginDescriptor.getArtifacts().\n\n");
            }
            this.resolveCoreArtifacts(unresolved, localRepository, resolutionGroup.getResolutionRepositories());
            ArrayList allResolved = new ArrayList(resolved.size() + unresolved.size());
            allResolved.addAll(resolved);
            allResolved.addAll(unresolved);
            pluginDescriptor.setArtifacts(allResolved);
        }
    }

    public static void checkPlexusUtils(ResolutionGroup resolutionGroup, ArtifactFactory artifactFactory) {
        VersionRange vr = null;
        try {
            vr = VersionRange.createFromVersionSpec((String)"[1.1,)");
        }
        catch (InvalidVersionSpecificationException e) {
            // empty catch block
        }
        boolean plexusUtilsPresent = false;
        Iterator i = resolutionGroup.getArtifacts().iterator();
        while (i.hasNext()) {
            Artifact a = (Artifact)i.next();
            if (!a.getArtifactId().equals("plexus-utils") || !vr.containsVersion((ArtifactVersion)new DefaultArtifactVersion(a.getVersion()))) continue;
            plexusUtilsPresent = true;
            break;
        }
        if (!plexusUtilsPresent) {
            resolutionGroup.getArtifacts().add(artifactFactory.createArtifact("org.codehaus.plexus", "plexus-utils", "1.1", "runtime", "jar"));
        }
    }

    private void resolveCoreArtifacts(List unresolved, ArtifactRepository localRepository, List resolutionRepositories) throws ArtifactResolutionException, ArtifactNotFoundException {
        Iterator it = unresolved.iterator();
        while (it.hasNext()) {
            Artifact artifact = (Artifact)it.next();
            File artifactFile = (File)this.resolvedCoreArtifactFiles.get(artifact.getId());
            if (artifactFile == null) {
                String resource = "/META-INF/maven/" + artifact.getGroupId() + "/" + artifact.getArtifactId() + "/pom.xml";
                URL resourceUrl = this.container.getContainerRealm().getResource(resource);
                if (resourceUrl == null) {
                    this.artifactResolver.resolve(artifact, resolutionRepositories, localRepository);
                    artifactFile = artifact.getFile();
                } else {
                    String artifactPath = resourceUrl.getPath();
                    if (artifactPath.startsWith("file:")) {
                        artifactPath = artifactPath.substring("file:".length());
                    }
                    if ((artifactPath = artifactPath.substring(0, artifactPath.length() - resource.length())).endsWith("/")) {
                        artifactPath = artifactPath.substring(0, artifactPath.length() - 1);
                    }
                    if (artifactPath.endsWith("!")) {
                        artifactPath = artifactPath.substring(0, artifactPath.length() - 1);
                    }
                    artifactFile = new File(artifactPath).getAbsoluteFile();
                }
                this.resolvedCoreArtifactFiles.put(artifact.getId(), artifactFile);
            }
            artifact.setFile(artifactFile);
        }
    }

    private PlexusConfiguration extractMojoConfiguration(PlexusConfiguration mergedConfiguration, MojoDescriptor mojoDescriptor) {
        Map parameterMap = mojoDescriptor.getParameterMap();
        PlexusConfiguration[] mergedChildren = mergedConfiguration.getChildren();
        XmlPlexusConfiguration extractedConfiguration = new XmlPlexusConfiguration("configuration");
        for (int i = 0; i < mergedChildren.length; ++i) {
            PlexusConfiguration child = mergedChildren[i];
            if (parameterMap.containsKey(child.getName())) {
                extractedConfiguration.addChild(DefaultPluginManager.copyConfiguration(child));
                continue;
            }
            this.getLogger().debug("*** WARNING: Configuration '" + child.getName() + "' is not used in goal '" + mojoDescriptor.getFullGoalName() + "; this may indicate a typo... ***");
        }
        return extractedConfiguration;
    }

    private void checkRequiredParameters(MojoDescriptor goal, PlexusConfiguration configuration, ExpressionEvaluator expressionEvaluator) throws PluginConfigurationException {
        List parameters = goal.getParameters();
        if (parameters == null) {
            return;
        }
        ArrayList<Parameter> invalidParameters = new ArrayList<Parameter>();
        for (int i = 0; i < parameters.size(); ++i) {
            Parameter parameter = (Parameter)parameters.get(i);
            if (!parameter.isRequired()) continue;
            String key = parameter.getName();
            Object fieldValue = null;
            String expression = null;
            PlexusConfiguration value = configuration.getChild(key, false);
            try {
                if (value != null && (fieldValue = expressionEvaluator.evaluate(expression = value.getValue(null))) == null) {
                    fieldValue = value.getAttribute("default-value", null);
                }
                if (fieldValue == null && StringUtils.isNotEmpty((String)parameter.getAlias()) && (value = configuration.getChild(parameter.getAlias(), false)) != null && (fieldValue = expressionEvaluator.evaluate(expression = value.getValue(null))) == null) {
                    fieldValue = value.getAttribute("default-value", null);
                }
            }
            catch (ExpressionEvaluationException e) {
                throw new PluginConfigurationException(goal.getPluginDescriptor(), e.getMessage(), e);
            }
            if (fieldValue != null || value != null && value.getChildCount() != 0) continue;
            parameter.setExpression(expression);
            invalidParameters.add(parameter);
        }
        if (!invalidParameters.isEmpty()) {
            throw new PluginParameterException(goal, invalidParameters);
        }
    }

    private void validatePomConfiguration(MojoDescriptor goal, PlexusConfiguration pomConfiguration) throws PluginConfigurationException {
        List parameters = goal.getParameters();
        if (parameters == null) {
            return;
        }
        for (int i = 0; i < parameters.size(); ++i) {
            Parameter parameter = (Parameter)parameters.get(i);
            String key = parameter.getName();
            PlexusConfiguration value = pomConfiguration.getChild(key, false);
            if (value == null && StringUtils.isNotEmpty((String)parameter.getAlias())) {
                key = parameter.getAlias();
                value = pomConfiguration.getChild(key, false);
            }
            if (value == null) continue;
            if (!parameter.isEditable()) {
                StringBuffer errorMessage = new StringBuffer().append("ERROR: Cannot override read-only parameter: ");
                errorMessage.append(key);
                errorMessage.append(" in goal: ").append(goal.getFullGoalName());
                throw new PluginConfigurationException(goal.getPluginDescriptor(), errorMessage.toString());
            }
            String deprecated = parameter.getDeprecated();
            if (!StringUtils.isNotEmpty((String)deprecated)) continue;
            this.getLogger().warn("DEPRECATED [" + parameter.getName() + "]: " + deprecated);
        }
    }

    private PlexusConfiguration mergeMojoConfiguration(XmlPlexusConfiguration fromPom, MojoDescriptor mojoDescriptor) {
        XmlPlexusConfiguration result = new XmlPlexusConfiguration(fromPom.getName());
        result.setValue(fromPom.getValue(null));
        if (mojoDescriptor.getParameters() != null) {
            PlexusConfiguration fromMojo = mojoDescriptor.getMojoConfiguration();
            Iterator it = mojoDescriptor.getParameters().iterator();
            while (it.hasNext()) {
                Parameter parameter = (Parameter)it.next();
                String paramName = parameter.getName();
                String alias = parameter.getAlias();
                String implementation = parameter.getImplementation();
                PlexusConfiguration pomConfig = fromPom.getChild(paramName);
                PlexusConfiguration aliased = null;
                if (alias != null) {
                    aliased = fromPom.getChild(alias);
                }
                PlexusConfiguration mojoConfig = fromMojo.getChild(paramName, false);
                if (aliased != null) {
                    if (pomConfig == null) {
                        pomConfig = new XmlPlexusConfiguration(paramName);
                    }
                    pomConfig = this.buildTopDownMergedConfiguration(pomConfig, aliased);
                }
                PlexusConfiguration toAdd = null;
                if (pomConfig != null && (StringUtils.isNotEmpty((String)(pomConfig = this.buildTopDownMergedConfiguration(pomConfig, mojoConfig)).getValue(null)) || pomConfig.getChildCount() > 0)) {
                    toAdd = pomConfig;
                }
                if (toAdd == null && mojoConfig != null) {
                    toAdd = DefaultPluginManager.copyConfiguration(mojoConfig);
                }
                if (toAdd == null) continue;
                if (implementation != null && toAdd.getAttribute("implementation", null) == null) {
                    XmlPlexusConfiguration implementationConf = new XmlPlexusConfiguration(paramName);
                    implementationConf.setAttribute("implementation", parameter.getImplementation());
                    toAdd = this.buildTopDownMergedConfiguration(toAdd, (PlexusConfiguration)implementationConf);
                }
                result.addChild(toAdd);
            }
        }
        return result;
    }

    private XmlPlexusConfiguration buildTopDownMergedConfiguration(PlexusConfiguration dominant, PlexusConfiguration recessive) {
        String attributeValue;
        int i;
        XmlPlexusConfiguration result = new XmlPlexusConfiguration(dominant.getName());
        String value = dominant.getValue(null);
        if (StringUtils.isEmpty((String)value) && recessive != null) {
            value = recessive.getValue(null);
        }
        if (StringUtils.isNotEmpty((String)value)) {
            result.setValue(value);
        }
        String[] attributeNames = dominant.getAttributeNames();
        for (i = 0; i < attributeNames.length; ++i) {
            attributeValue = dominant.getAttribute(attributeNames[i], null);
            result.setAttribute(attributeNames[i], attributeValue);
        }
        if (recessive != null) {
            attributeNames = recessive.getAttributeNames();
            for (i = 0; i < attributeNames.length; ++i) {
                attributeValue = recessive.getAttribute(attributeNames[i], null);
                result.setAttribute(attributeNames[i], attributeValue);
            }
        }
        PlexusConfiguration[] children = dominant.getChildren();
        for (int i2 = 0; i2 < children.length; ++i2) {
            PlexusConfiguration childRec;
            PlexusConfiguration childDom = children[i2];
            PlexusConfiguration plexusConfiguration = childRec = recessive == null ? null : recessive.getChild(childDom.getName(), false);
            if (childRec != null) {
                result.addChild((PlexusConfiguration)this.buildTopDownMergedConfiguration(childDom, childRec));
                continue;
            }
            result.addChild(DefaultPluginManager.copyConfiguration(childDom));
        }
        return result;
    }

    public static PlexusConfiguration copyConfiguration(PlexusConfiguration src) {
        XmlPlexusConfiguration dom = new XmlPlexusConfiguration(src.getName());
        dom.setValue(src.getValue(null));
        String[] attributeNames = src.getAttributeNames();
        for (int i = 0; i < attributeNames.length; ++i) {
            String attributeName = attributeNames[i];
            dom.setAttribute(attributeName, src.getAttribute(attributeName, null));
        }
        PlexusConfiguration[] children = src.getChildren();
        for (int i = 0; i < children.length; ++i) {
            dom.addChild(DefaultPluginManager.copyConfiguration(children[i]));
        }
        return dom;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void populatePluginFields(Mojo plugin, MojoDescriptor mojoDescriptor, PlexusConfiguration configuration, PlexusContainer pluginContainer, ExpressionEvaluator expressionEvaluator) throws PluginConfigurationException {
        ComponentConfigurator configurator = null;
        try {
            String configuratorId = mojoDescriptor.getComponentConfigurator();
            configurator = StringUtils.isNotEmpty((String)configuratorId) ? (ComponentConfigurator)pluginContainer.lookup(ComponentConfigurator.ROLE, configuratorId) : (ComponentConfigurator)pluginContainer.lookup(ComponentConfigurator.ROLE);
            DebugConfigurationListener listener = new DebugConfigurationListener(this.getLogger());
            this.getLogger().debug("Configuring mojo '" + mojoDescriptor.getId() + "' -->");
            configurator.configureComponent((Object)plugin, configuration, expressionEvaluator, pluginContainer.getContainerRealm(), (ConfigurationListener)listener);
            this.getLogger().debug("-- end configuration --");
            if (configurator == null) return;
        }
        catch (ComponentConfigurationException e) {
            try {
                throw new PluginConfigurationException(mojoDescriptor.getPluginDescriptor(), "Unable to parse the created DOM for plugin configuration", e);
                catch (ComponentLookupException e2) {
                    throw new PluginConfigurationException(mojoDescriptor.getPluginDescriptor(), "Unable to retrieve component configurator for plugin configuration", e2);
                }
                catch (LinkageError e3) {
                    if (!this.getLogger().isFatalErrorEnabled()) throw new PluginConfigurationException(mojoDescriptor.getPluginDescriptor(), e3.getClass().getName() + ": " + e3.getMessage(), e3);
                    this.getLogger().fatalError(configurator.getClass().getName() + "#configureComponent(...) caused a linkage error (" + e3.getClass().getName() + ") and may be out-of-date. Check the realms:");
                    ClassRealm pluginRealm = mojoDescriptor.getPluginDescriptor().getClassRealm();
                    StringBuffer sb = new StringBuffer();
                    sb.append("Plugin realm = " + pluginRealm.getId()).append('\n');
                    for (int i = 0; i < pluginRealm.getConstituents().length; ++i) {
                        sb.append("urls[" + i + "] = " + pluginRealm.getConstituents()[i]);
                        if (i == pluginRealm.getConstituents().length - 1) continue;
                        sb.append('\n');
                    }
                    this.getLogger().fatalError(sb.toString());
                    ClassRealm containerRealm = this.container.getContainerRealm();
                    sb = new StringBuffer();
                    sb.append("Container realm = " + containerRealm.getId()).append('\n');
                    int i = 0;
                    while (true) {
                        if (i >= containerRealm.getConstituents().length) {
                            this.getLogger().fatalError(sb.toString());
                            throw new PluginConfigurationException(mojoDescriptor.getPluginDescriptor(), e3.getClass().getName() + ": " + e3.getMessage(), e3);
                        }
                        sb.append("urls[" + i + "] = " + containerRealm.getConstituents()[i]);
                        if (i != containerRealm.getConstituents().length - 1) {
                            sb.append('\n');
                        }
                        ++i;
                    }
                }
            }
            catch (Throwable throwable) {
                if (configurator == null) throw throwable;
                try {
                    pluginContainer.release(configurator);
                    throw throwable;
                }
                catch (ComponentLifecycleException e4) {
                    this.getLogger().debug("Failed to release plugin container - ignoring.");
                }
                throw throwable;
            }
        }
        try {
            pluginContainer.release((Object)configurator);
            return;
        }
        catch (ComponentLifecycleException e) {
            this.getLogger().debug("Failed to release plugin container - ignoring.");
            return;
        }
    }

    public static String createPluginParameterRequiredMessage(MojoDescriptor mojo, Parameter parameter, String expression) {
        StringBuffer message = new StringBuffer();
        message.append("The '");
        message.append(parameter.getName());
        message.append("' parameter is required for the execution of the ");
        message.append(mojo.getFullGoalName());
        message.append(" mojo and cannot be null.");
        if (expression != null) {
            message.append(" The retrieval expression was: ").append(expression);
        }
        return message.toString();
    }

    public void contextualize(Context context) throws ContextException {
        this.container = (PlexusContainer)context.get((Object)"plexus");
        this.mojoLogger = new DefaultLog(this.container.getLoggerManager().getLoggerForComponent(Mojo.ROLE));
    }

    public void initialize() {
        this.artifactFilter = MavenArtifactFilterManager.createStandardFilter();
    }

    private void resolveTransitiveDependencies(MavenSession context, ArtifactResolver artifactResolver, String scope, ArtifactFactory artifactFactory, MavenProject project, boolean isAggregator) throws ArtifactResolutionException, ArtifactNotFoundException, InvalidDependencyVersionException {
        Set resolvedArtifacts;
        ScopeArtifactFilter filter = new ScopeArtifactFilter(scope);
        Artifact artifact = artifactFactory.createBuildArtifact(project.getGroupId(), project.getArtifactId(), project.getVersion(), project.getPackaging());
        if (project.getDependencyArtifacts() == null) {
            project.setDependencyArtifacts(project.createArtifacts(artifactFactory, null, null));
        }
        try {
            ArtifactResolutionResult result = artifactResolver.resolveTransitively(project.getDependencyArtifacts(), artifact, project.getManagedVersionMap(), context.getLocalRepository(), project.getRemoteArtifactRepositories(), this.artifactMetadataSource, (ArtifactFilter)filter);
            resolvedArtifacts = result.getArtifacts();
        }
        catch (MultipleArtifactsNotFoundException me) {
            if (isAggregator && this.checkMissingArtifactsInReactor(context.getSortedProjects(), me.getMissingArtifacts())) {
                resolvedArtifacts = new HashSet(me.getResolvedArtifacts());
            }
            throw me;
        }
        project.setArtifacts(resolvedArtifacts);
    }

    private boolean checkMissingArtifactsInReactor(Collection projects, Collection missing) {
        HashSet<MavenProject> foundInReactor = new HashSet<MavenProject>();
        Iterator iter = missing.iterator();
        block0: while (iter.hasNext()) {
            Artifact mArtifact = (Artifact)iter.next();
            Iterator pIter = projects.iterator();
            while (pIter.hasNext()) {
                MavenProject p = (MavenProject)pIter.next();
                if (!p.getArtifactId().equals(mArtifact.getArtifactId()) || !p.getGroupId().equals(mArtifact.getGroupId()) || !p.getVersion().equals(mArtifact.getVersion())) continue;
                this.getLogger().warn("The dependency: " + p.getId() + " can't be resolved but has been found in the reactor.\nThis dependency has been excluded from the plugin execution. You should rerun this mojo after executing mvn install.\n");
                foundInReactor.add(p);
                continue block0;
            }
        }
        return foundInReactor.size() == missing.size();
    }

    private void downloadDependencies(MavenProject project, MavenSession context, ArtifactResolver artifactResolver) throws ArtifactResolutionException, ArtifactNotFoundException {
        ArtifactRepository localRepository = context.getLocalRepository();
        List remoteArtifactRepositories = project.getRemoteArtifactRepositories();
        Iterator it = project.getArtifacts().iterator();
        while (it.hasNext()) {
            Artifact artifact = (Artifact)it.next();
            artifactResolver.resolve(artifact, remoteArtifactRepositories, localRepository);
        }
    }

    public Object getPluginComponent(Plugin plugin, String role, String roleHint) throws PluginManagerException, ComponentLookupException {
        PluginDescriptor pluginDescriptor = this.pluginCollector.getPluginDescriptor(plugin);
        PlexusContainer pluginContainer = this.getPluginContainer(pluginDescriptor);
        return pluginContainer.lookup(role, roleHint);
    }

    public Map getPluginComponents(Plugin plugin, String role) throws ComponentLookupException, PluginManagerException {
        PluginDescriptor pluginDescriptor = this.pluginCollector.getPluginDescriptor(plugin);
        PlexusContainer pluginContainer = this.getPluginContainer(pluginDescriptor);
        return pluginContainer.lookupMap(role);
    }
}

