/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.assembly.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.assembly.model.ContainerDescriptorHandlerConfig;
import org.apache.maven.plugin.assembly.model.DependencySet;
import org.apache.maven.plugin.assembly.model.FileItem;
import org.apache.maven.plugin.assembly.model.FileSet;
import org.apache.maven.plugin.assembly.model.ModuleSet;
import org.apache.maven.plugin.assembly.model.Repository;

public class Component
implements Serializable {
    private List<ModuleSet> moduleSets;
    private List<FileSet> fileSets;
    private List<FileItem> files;
    private List<DependencySet> dependencySets;
    private List<Repository> repositories;
    private List<ContainerDescriptorHandlerConfig> containerDescriptorHandlers;
    private String modelEncoding = "UTF-8";

    public void addContainerDescriptorHandler(ContainerDescriptorHandlerConfig containerDescriptorHandlerConfig) {
        this.getContainerDescriptorHandlers().add(containerDescriptorHandlerConfig);
    }

    public void addDependencySet(DependencySet dependencySet) {
        this.getDependencySets().add(dependencySet);
    }

    public void addFile(FileItem fileItem) {
        this.getFiles().add(fileItem);
    }

    public void addFileSet(FileSet fileSet) {
        this.getFileSets().add(fileSet);
    }

    public void addModuleSet(ModuleSet moduleSet) {
        this.getModuleSets().add(moduleSet);
    }

    public void addRepository(Repository repository) {
        this.getRepositories().add(repository);
    }

    public List<ContainerDescriptorHandlerConfig> getContainerDescriptorHandlers() {
        if (this.containerDescriptorHandlers == null) {
            this.containerDescriptorHandlers = new ArrayList<ContainerDescriptorHandlerConfig>();
        }
        return this.containerDescriptorHandlers;
    }

    public List<DependencySet> getDependencySets() {
        if (this.dependencySets == null) {
            this.dependencySets = new ArrayList<DependencySet>();
        }
        return this.dependencySets;
    }

    public List<FileSet> getFileSets() {
        if (this.fileSets == null) {
            this.fileSets = new ArrayList<FileSet>();
        }
        return this.fileSets;
    }

    public List<FileItem> getFiles() {
        if (this.files == null) {
            this.files = new ArrayList<FileItem>();
        }
        return this.files;
    }

    public String getModelEncoding() {
        return this.modelEncoding;
    }

    public List<ModuleSet> getModuleSets() {
        if (this.moduleSets == null) {
            this.moduleSets = new ArrayList<ModuleSet>();
        }
        return this.moduleSets;
    }

    public List<Repository> getRepositories() {
        if (this.repositories == null) {
            this.repositories = new ArrayList<Repository>();
        }
        return this.repositories;
    }

    public void removeContainerDescriptorHandler(ContainerDescriptorHandlerConfig containerDescriptorHandlerConfig) {
        this.getContainerDescriptorHandlers().remove(containerDescriptorHandlerConfig);
    }

    public void removeDependencySet(DependencySet dependencySet) {
        this.getDependencySets().remove(dependencySet);
    }

    public void removeFile(FileItem fileItem) {
        this.getFiles().remove(fileItem);
    }

    public void removeFileSet(FileSet fileSet) {
        this.getFileSets().remove(fileSet);
    }

    public void removeModuleSet(ModuleSet moduleSet) {
        this.getModuleSets().remove(moduleSet);
    }

    public void removeRepository(Repository repository) {
        this.getRepositories().remove(repository);
    }

    public void setContainerDescriptorHandlers(List<ContainerDescriptorHandlerConfig> containerDescriptorHandlers) {
        this.containerDescriptorHandlers = containerDescriptorHandlers;
    }

    public void setDependencySets(List<DependencySet> dependencySets) {
        this.dependencySets = dependencySets;
    }

    public void setFileSets(List<FileSet> fileSets) {
        this.fileSets = fileSets;
    }

    public void setFiles(List<FileItem> files) {
        this.files = files;
    }

    public void setModelEncoding(String modelEncoding) {
        this.modelEncoding = modelEncoding;
    }

    public void setModuleSets(List<ModuleSet> moduleSets) {
        this.moduleSets = moduleSets;
    }

    public void setRepositories(List<Repository> repositories) {
        this.repositories = repositories;
    }
}

