/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.eclipse;

import java.io.File;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.eclipse.EclipseConfigFile;
import org.apache.maven.plugin.ide.IdeUtils;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="clean")
public class EclipseCleanMojo
extends AbstractMojo {
    private static final String FILE_DOT_WTPMODULES = ".wtpmodules";
    private static final String FILE_DOT_CLASSPATH = ".classpath";
    private static final String FILE_DOT_PROJECT = ".project";
    @Parameter(property="project.packaging")
    private String packaging;
    @Parameter(property="basedir")
    private File basedir;
    @Parameter(property="eclipse.skip", defaultValue="false")
    private boolean skip;
    @Parameter
    private EclipseConfigFile[] additionalConfig;

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            return;
        }
        if ("pom".equals(this.packaging)) {
            return;
        }
        this.delete(new File(this.basedir, FILE_DOT_PROJECT));
        this.delete(new File(this.basedir, FILE_DOT_CLASSPATH));
        this.delete(new File(this.basedir, FILE_DOT_WTPMODULES));
        this.delete(new File(this.basedir, ".settings"));
        if (this.additionalConfig != null) {
            for (EclipseConfigFile anAdditionalConfig : this.additionalConfig) {
                this.delete(new File(this.basedir, anAdditionalConfig.getName()));
            }
        }
        this.cleanExtras();
    }

    protected void cleanExtras() throws MojoExecutionException {
    }

    protected void delete(File f) throws MojoExecutionException {
        IdeUtils.delete(f, this.getLog());
    }

    public File getBasedir() {
        return this.basedir;
    }

    public void setBasedir(File basedir) {
        this.basedir = basedir;
    }

    public String getPackaging() {
        return this.packaging;
    }

    public void setPackaging(String packaging) {
        this.packaging = packaging;
    }
}

