/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.release;

import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.release.AbstractReleaseMojo;
import org.apache.maven.scm.manager.ScmManager;
import org.apache.maven.shared.release.config.ReleaseDescriptor;

public abstract class AbstractScmReleaseMojo
extends AbstractReleaseMojo {
    @Parameter(property="username")
    private String username;
    @Parameter(property="password")
    private String password;
    @Parameter(alias="releaseLabel", property="tag")
    private String tag;
    @Parameter(defaultValue="@{project.artifactId}-@{project.version}", property="tagNameFormat")
    private String tagNameFormat;
    @Parameter(property="tagBase")
    private String tagBase;
    @Parameter(defaultValue="[maven-release-plugin] ", property="scmCommentPrefix")
    private String scmCommentPrefix;
    @Parameter(defaultValue="true", property="pushChanges")
    private boolean pushChanges = true;
    @Parameter
    private Map<String, String> providerImplementations;
    @Component
    private ScmManager scmManager;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.providerImplementations != null) {
            for (Map.Entry<String, String> providerEntry : this.providerImplementations.entrySet()) {
                this.getLog().info((CharSequence)("Change the default '" + providerEntry.getKey() + "' provider implementation to '" + providerEntry.getValue() + "'."));
                this.scmManager.setScmProviderImplementation(providerEntry.getKey(), providerEntry.getValue());
            }
        }
    }

    @Override
    protected ReleaseDescriptor createReleaseDescriptor() {
        ReleaseDescriptor descriptor = super.createReleaseDescriptor();
        descriptor.setScmPassword(this.password);
        descriptor.setScmReleaseLabel(this.tag);
        descriptor.setScmTagNameFormat(this.tagNameFormat);
        descriptor.setScmTagBase(this.tagBase);
        descriptor.setScmUsername(this.username);
        descriptor.setScmCommentPrefix(this.scmCommentPrefix);
        descriptor.setPushChanges(this.pushChanges);
        return descriptor;
    }
}

