/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.shade.resource;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.apache.maven.plugins.shade.relocation.Relocator;
import org.apache.maven.plugins.shade.resource.ResourceTransformer;

public class ManifestResourceTransformer
implements ResourceTransformer {
    private String mainClass;
    private Map<String, Object> manifestEntries;
    private boolean manifestDiscovered;
    private Manifest manifest;

    @Override
    public boolean canTransformResource(String resource) {
        return "META-INF/MANIFEST.MF".equalsIgnoreCase(resource);
    }

    @Override
    public void processResource(String resource, InputStream is, List<Relocator> relocators) throws IOException {
        if (!this.manifestDiscovered) {
            this.manifest = new Manifest(is);
            this.manifestDiscovered = true;
        }
    }

    @Override
    public boolean hasTransformedResource() {
        return true;
    }

    @Override
    public void modifyOutputStream(JarOutputStream jos) throws IOException {
        if (this.manifest == null) {
            this.manifest = new Manifest();
        }
        Attributes attributes = this.manifest.getMainAttributes();
        if (this.mainClass != null) {
            attributes.put(Attributes.Name.MAIN_CLASS, this.mainClass);
        }
        if (this.manifestEntries != null) {
            for (Map.Entry<String, Object> entry : this.manifestEntries.entrySet()) {
                attributes.put(new Attributes.Name(entry.getKey()), entry.getValue());
            }
        }
        jos.putNextEntry(new JarEntry("META-INF/MANIFEST.MF"));
        this.manifest.write(jos);
    }
}

