/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire.report;

import java.io.BufferedOutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.List;
import org.apache.maven.plugin.surefire.report.TestSetStats;
import org.apache.maven.plugin.surefire.report.WrappedReportEntry;
import org.apache.maven.surefire.report.ReportEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConsoleReporter {
    public static final String BRIEF = "brief";
    public static final String PLAIN = "plain";
    private static final String TEST_SET_STARTING_PREFIX = "Running ";
    private static final int BUFFER_SIZE = 4096;
    private final PrintWriter writer;

    public ConsoleReporter(PrintStream originalSystemOut) {
        OutputStreamWriter out = new OutputStreamWriter(new BufferedOutputStream(originalSystemOut, 4096));
        this.writer = new PrintWriter(out);
    }

    public void testSetStarting(ReportEntry report) {
        this.writeMessage(ConsoleReporter.getTestSetStartingMessage(report));
    }

    public void writeMessage(String message) {
        this.writer.print(message);
        this.writer.flush();
    }

    public void writeLnMessage(String message) {
        this.writer.println(message);
        this.writer.flush();
    }

    public void testSetCompleted(WrappedReportEntry report, TestSetStats testSetStats, List<String> testResults) {
        this.writeMessage(testSetStats.getTestSetSummary(report));
        if (testResults != null) {
            for (String testResult : testResults) {
                this.writeLnMessage(testResult);
            }
        }
    }

    public void reset() {
        this.writer.flush();
    }

    static String getTestSetStartingMessage(ReportEntry report) {
        return TEST_SET_STARTING_PREFIX + report.getNameWithGroup() + "\n";
    }
}

