/*
 * Decompiled with CFR 0.152.
 */
package groovy.servlet;

import groovy.lang.Binding;
import groovy.xml.MarkupBuilder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.codehaus.groovy.GroovyBugError;

public class ServletBinding
extends Binding {
    private boolean initialized;

    public ServletBinding(HttpServletRequest request, HttpServletResponse response, ServletContext context) {
        super.setVariable("request", request);
        super.setVariable("response", response);
        super.setVariable("context", context);
        super.setVariable("application", context);
        super.setVariable("session", request.getSession(false));
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        Enumeration names = request.getParameterNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            if (super.getVariables().containsKey(name)) continue;
            String[] values = request.getParameterValues(name);
            if (values.length == 1) {
                params.put(name, values[0]);
                continue;
            }
            params.put(name, values);
        }
        super.setVariable("params", params);
        LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>();
        Enumeration names2 = request.getHeaderNames();
        while (names2.hasMoreElements()) {
            String headerName = (String)names2.nextElement();
            String headerValue = request.getHeader(headerName);
            headers.put(headerName, headerValue);
        }
        super.setVariable("headers", headers);
    }

    public void setVariable(String name, Object value) {
        this.lazyInit();
        this.validateArgs(name, "Can't bind variable to");
        this.excludeReservedName(name, "out");
        this.excludeReservedName(name, "sout");
        this.excludeReservedName(name, "html");
        super.setVariable(name, value);
    }

    public Map getVariables() {
        this.lazyInit();
        return super.getVariables();
    }

    public Object getVariable(String name) {
        this.lazyInit();
        this.validateArgs(name, "No variable with");
        return super.getVariable(name);
    }

    private void lazyInit() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        HttpServletResponse response = (HttpServletResponse)super.getVariable("response");
        ServletContext context = (ServletContext)super.getVariable("context");
        ServletOutput output = new ServletOutput(response);
        super.setVariable("out", output.getWriter());
        super.setVariable("sout", output.getOutputStream());
        super.setVariable("html", new MarkupBuilder(output.getWriter()));
    }

    private void validateArgs(String name, String message) {
        if (name == null) {
            throw new IllegalArgumentException(message + " null key.");
        }
        if (name.length() == 0) {
            throw new IllegalArgumentException(message + " blank key name. [length=0]");
        }
    }

    private void excludeReservedName(String name, String reservedName) {
        if (reservedName.equals(name)) {
            throw new IllegalArgumentException("Can't bind variable to key named '" + name + "'.");
        }
    }

    private static class ServletOutput {
        private HttpServletResponse response;
        private ServletOutputStream outputStream;
        private PrintWriter writer;

        public ServletOutput(HttpServletResponse response) {
            this.response = response;
        }

        private ServletOutputStream getResponseStream() throws IOException {
            if (this.writer != null) {
                throw new IllegalStateException("The variable 'out' or 'html' have been used already. Use either out/html or sout, not both.");
            }
            if (this.outputStream == null) {
                this.outputStream = this.response.getOutputStream();
            }
            return this.outputStream;
        }

        public ServletOutputStream getOutputStream() {
            return new ServletOutputStream(){

                public void write(int b) throws IOException {
                    ServletOutput.this.getResponseStream().write(b);
                }

                public void close() throws IOException {
                    ServletOutput.this.getResponseStream().close();
                }

                public void flush() throws IOException {
                    ServletOutput.this.getResponseStream().flush();
                }

                public void write(byte[] b) throws IOException {
                    ServletOutput.this.getResponseStream().write(b);
                }

                public void write(byte[] b, int off, int len) throws IOException {
                    ServletOutput.this.getResponseStream().write(b, off, len);
                }
            };
        }

        private PrintWriter getResponseWriter() {
            if (this.outputStream != null) {
                throw new IllegalStateException("The variable 'sout' have been used already. Use either out/html or sout, not both.");
            }
            if (this.writer == null) {
                try {
                    this.writer = this.response.getWriter();
                }
                catch (IOException ioe) {
                    this.writer = new PrintWriter(new ByteArrayOutputStream());
                    throw new IllegalStateException("Unable to get response writer: " + ioe.getMessage());
                }
            }
            return this.writer;
        }

        public PrintWriter getWriter() {
            return new PrintWriter(new InvalidOutputStream()){

                public boolean checkError() {
                    return ServletOutput.this.getResponseWriter().checkError();
                }

                public void close() {
                    ServletOutput.this.getResponseWriter().close();
                }

                public void flush() {
                    ServletOutput.this.getResponseWriter().flush();
                }

                public void write(char[] buf) {
                    ServletOutput.this.getResponseWriter().write(buf);
                }

                public void write(char[] buf, int off, int len) {
                    ServletOutput.this.getResponseWriter().write(buf, off, len);
                }

                public void write(int c) {
                    ServletOutput.this.getResponseWriter().write(c);
                }

                public void write(String s, int off, int len) {
                    ServletOutput.this.getResponseWriter().write(s, off, len);
                }

                public void println() {
                    ServletOutput.this.getResponseWriter().println();
                }
            };
        }
    }

    private static class InvalidOutputStream
    extends OutputStream {
        private InvalidOutputStream() {
        }

        public void write(int b) {
            throw new GroovyBugError("Any write calls to this stream are invalid!");
        }
    }
}

