/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql;

public enum JPAVersion {
    DEFAULT_VERSION(2.1),
    VERSION_1_0(1.0),
    VERSION_2_0(2.0),
    VERSION_2_1(2.1);

    private double version;

    private JPAVersion(double version) {
        this.version = version;
    }

    public static JPAVersion value(String value) {
        JPAVersion[] jPAVersionArray = JPAVersion.versions();
        int n = jPAVersionArray.length;
        int n2 = 0;
        while (n2 < n) {
            JPAVersion version = jPAVersionArray[n2];
            if (version.getVersion().equals(value)) {
                return version;
            }
            ++n2;
        }
        return DEFAULT_VERSION;
    }

    public static JPAVersion[] versions() {
        JPAVersion[] values = new JPAVersion[]{VERSION_1_0, VERSION_2_0, VERSION_2_1};
        return values;
    }

    public String getVersion() {
        return String.valueOf(this.version);
    }

    public boolean isNewerThan(JPAVersion version) {
        return this.version > version.version;
    }

    public boolean isNewerThanOrEqual(JPAVersion version) {
        return this.version >= version.version;
    }

    public boolean isOlderThan(JPAVersion version) {
        return this.version < version.version;
    }

    public boolean isOlderThanOrEqual(JPAVersion version) {
        return this.version <= version.version;
    }

    public JPAVersion toCurrentVersion() {
        if (this == DEFAULT_VERSION) {
            String currentVersion = this.getVersion();
            JPAVersion[] jPAVersionArray = JPAVersion.versions();
            int n = jPAVersionArray.length;
            int n2 = 0;
            while (n2 < n) {
                JPAVersion version = jPAVersionArray[n2];
                if (currentVersion.equals(version.version)) {
                    return version;
                }
                ++n2;
            }
        }
        return this;
    }

    public String toString() {
        return this.getVersion();
    }
}

