/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.containers;

import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provides;
import java.util.Collections;
import java.util.Map;
import javax.inject.Inject;
import org.eclipse.sisu.BeanScanning;
import org.eclipse.sisu.Parameters;
import org.eclipse.sisu.binders.ParameterKeys;
import org.eclipse.sisu.binders.SpaceModule;
import org.eclipse.sisu.binders.WireModule;
import org.eclipse.sisu.containers.SisuGuice;
import org.eclipse.sisu.locators.MutableBeanLocator;
import org.eclipse.sisu.reflect.URLClassSpace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Main
implements Module {
    private final Map<?, ?> properties;
    private final String[] args;

    private Main(Map<?, ?> properties, String ... args) {
        this.properties = Collections.unmodifiableMap(properties);
        this.args = args;
    }

    public static void main(String ... args) {
        Main.boot(System.getProperties(), args);
    }

    public static <T> T boot(Class<T> type, String ... args) {
        return (T)Main.boot(System.getProperties(), args).getInstance(type);
    }

    public static Injector boot(Map<?, ?> properties, String ... args) {
        BeanScanning scanning = Main.selectScanning(properties);
        Module app = Main.wire(scanning, new Main(properties, args));
        Injector injector = Guice.createInjector((Module[])new Module[]{app});
        return injector;
    }

    public static Module wire(BeanScanning scanning, Module ... bindings) {
        Module[] modules = new Module[bindings.length + 1];
        System.arraycopy(bindings, 0, modules, 0, bindings.length);
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        modules[bindings.length] = new SpaceModule(new URLClassSpace(tccl), scanning);
        return new WireModule(modules);
    }

    public void configure(Binder binder) {
        binder.requestStaticInjection(new Class[]{SisuGuice.class});
        binder.bind(ParameterKeys.PROPERTIES).toInstance(this.properties);
        binder.bind(ShutdownThread.class).asEagerSingleton();
    }

    @Provides
    @Parameters
    String[] parameters() {
        return (String[])this.args.clone();
    }

    static BeanScanning selectScanning(Map<?, ?> properties) {
        String option = (String)properties.get(BeanScanning.class.getName());
        if (option == null || option.length() == 0) {
            return BeanScanning.ON;
        }
        BeanScanning[] beanScanningArray = BeanScanning.values();
        int n = beanScanningArray.length;
        int n2 = 0;
        while (n2 < n) {
            BeanScanning value = beanScanningArray[n2];
            if (value.name().equalsIgnoreCase(option)) {
                return value;
            }
            ++n2;
        }
        throw new IllegalArgumentException("Unknown BeanScanning option: " + option);
    }

    static final class ShutdownThread
    extends Thread {
        private final MutableBeanLocator locator;

        @Inject
        ShutdownThread(MutableBeanLocator locator) {
            this.locator = locator;
            Runtime.getRuntime().addShutdownHook(this);
        }

        public void run() {
            this.locator.clear();
        }
    }
}

