/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.reflect;

import java.io.File;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class FileEntryIterator
implements Iterator<String> {
    private final String rootPath;
    private final LinkedList<String> entryNames = new LinkedList();
    private final boolean recurse;

    FileEntryIterator(URL url, String subPath, boolean recurse) {
        this.rootPath = FileEntryIterator.normalizePath(FileEntryIterator.toFile(url).getAbsoluteFile());
        this.recurse = recurse;
        this.appendEntries(subPath);
    }

    @Override
    public boolean hasNext() {
        return this.entryNames.size() > 0;
    }

    @Override
    public String next() {
        String name = this.entryNames.removeFirst();
        if (this.recurse && name.endsWith("/")) {
            this.appendEntries(name);
        }
        return name;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    static File toFile(URL url) {
        StringBuilder buf = new StringBuilder();
        String path = url.getPath();
        int i = 0;
        int length = path.length();
        while (i < length) {
            char c = path.charAt(i);
            if ('/' == c) {
                buf.append(File.separatorChar);
            } else if ('%' == c && i < length - 2) {
                int hi = Character.digit(path.charAt(i + 1), 16);
                int lo = Character.digit(path.charAt(i + 2), 16);
                if (hi >= 0 && lo >= 0) {
                    buf.append((char)(hi << 4 | lo));
                    i += 2;
                } else {
                    buf.append('%');
                }
            } else {
                buf.append(c);
            }
            ++i;
        }
        return new File(buf.toString());
    }

    private void appendEntries(String subPath) {
        File[] listing = new File(String.valueOf(this.rootPath) + subPath).listFiles();
        if (listing != null) {
            File[] fileArray = listing;
            int n = listing.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                this.entryNames.add(FileEntryIterator.normalizePath(f).substring(this.rootPath.length()));
                ++n2;
            }
        }
    }

    private static String normalizePath(File file) {
        return file.toURI().getPath();
    }
}

